/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class HollowUIRouter
extends HttpServlet {
    protected final String baseUrlPath;
    protected final VelocityEngine velocityEngine;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.handle(request.getPathInfo(), request, response);
        }
        catch (Exception ex) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ex.printStackTrace(printWriter);
            response.sendError(500, stringWriter.toString());
        }
    }

    public abstract boolean handle(String var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    public HollowUIRouter(String baseUrlPath) {
        if (!baseUrlPath.startsWith("/")) {
            baseUrlPath = "/" + baseUrlPath;
        }
        if (baseUrlPath.endsWith("/")) {
            baseUrlPath = baseUrlPath.substring(0, baseUrlPath.length() - 1);
        }
        this.baseUrlPath = baseUrlPath;
        this.velocityEngine = this.initVelocity();
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public String getBaseURLPath() {
        return this.baseUrlPath;
    }

    protected String getTargetRootPath(String target) {
        int baseLength = this.baseUrlPath.length() + 1;
        if (target.length() < baseLength) {
            return "";
        }
        if (target == null) {
            throw new IllegalStateException("target is null. It defaults to HttpServletRequest::getPathInfo() but can be customized by invoking handle method on HollowExplorerUI HollowDiffUI et al classes.");
        }
        int secondSlashIndex = target.indexOf(47, baseLength);
        if (secondSlashIndex == -1) {
            return target.substring(baseLength);
        }
        return target.substring(baseLength, secondSlashIndex);
    }

    protected String getResourceName(String target, String diffUIKey) {
        if (diffUIKey == null || diffUIKey.length() == 0) {
            int baseLength = this.baseUrlPath.length() + 1;
            int secondSlashIndex = target.indexOf(47, baseLength);
            if (secondSlashIndex == -1 && (secondSlashIndex = target.indexOf(47)) == -1) {
                return "";
            }
            return target.substring(secondSlashIndex + 1);
        }
        return this.getResourceName(target);
    }

    protected String getResourceName(String target) {
        int baseLength = this.baseUrlPath.length() + 1;
        int secondSlashIndex = target.indexOf(47, baseLength);
        if (secondSlashIndex == -1) {
            return "";
        }
        return target.substring(secondSlashIndex + 1);
    }

    protected boolean serveResource(HttpServletRequest req, HttpServletResponse resp, String resourceName) {
        try {
            if (resourceName.endsWith(".css")) {
                resp.setContentType("text/css");
            } else if (resourceName.endsWith(".js")) {
                resp.setContentType("text/javascript");
            } else if (resourceName.endsWith(".png")) {
                resp.setContentType("image/png");
            }
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + resourceName);
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected VelocityEngine initVelocity() {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        ve.setProperty("runtime.log.logsystem.log4j.category", (Object)"velocity");
        ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)"velocity");
        ve.init();
        return ve;
    }
}

