/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui;

import com.netflix.hollow.core.util.Threads;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HollowUISession {
    private static final long SESSION_ABANDONMENT_MILLIS = 3600000L;
    private static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private final Map<String, Object> sessionParams = new ConcurrentHashMap<String, Object>();
    private long lastAccessed;
    private static final ConcurrentHashMap<Long, HollowUISession> sessions = new ConcurrentHashMap();

    public void clearAttribute(String param) {
        this.sessionParams.remove(param);
    }

    public void setAttribute(String param, Object value) {
        this.sessionParams.put(param, value);
    }

    public Object getAttribute(String param) {
        return this.sessionParams.get(param);
    }

    public void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public static HollowUISession getSession(HttpServletRequest req, HttpServletResponse resp) {
        HollowUISession existingSession;
        HollowUISession session;
        Long sessionId = null;
        if (req.getCookies() != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!"hollowUISessionId".equals(cookie.getName())) continue;
                sessionId = Long.valueOf(cookie.getValue());
            }
        }
        if (sessionId == null) {
            sessionId = new Random().nextLong() & Long.MAX_VALUE;
            Cookie cookie = new Cookie("hollowUISessionId", sessionId.toString());
            cookie.setComment(HTTP_ONLY_COMMENT);
            resp.addCookie(cookie);
        }
        if ((session = sessions.get(sessionId)) == null && (existingSession = sessions.putIfAbsent(sessionId, session = new HollowUISession())) != null) {
            session = existingSession;
        }
        session.updateLastAccessed();
        return session;
    }

    private static void cleanupSessions() {
        while (!Thread.currentThread().isInterrupted()) {
            sessions.values().removeIf(s -> s.lastAccessed + 3600000L < System.currentTimeMillis());
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        Threads.daemonThread(HollowUISession::cleanupSessions, HollowUISession.class, (String)"session-cleanup").start();
    }
}

