/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui;

import com.netflix.hollow.ui.HttpHandlerWithServletSupport;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HollowUIWebServer {
    private HttpServer server;
    private final HttpHandlerWithServletSupport handler;
    private final int port;
    private JoinableExecutorService executor;

    public HollowUIWebServer(HttpHandlerWithServletSupport handler, int port) {
        this.port = port;
        this.handler = handler;
        this.executor = new JoinableExecutorService();
    }

    public void start() throws Exception {
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/", this.handler);
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.executor.join();
    }

    public void stop() throws Exception {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("Http Server ThreadPool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
        }
        this.server.stop(0);
    }

    private static class JoinableExecutorService
    extends ThreadPoolExecutor {
        private CountDownLatch countDownLatch = new CountDownLatch(1);

        JoinableExecutorService() {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void terminated() {
            super.terminated();
            this.countDownLatch.countDown();
        }

        void join() throws InterruptedException {
            this.countDownLatch.await();
        }
    }
}

