/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpUtils;

public class HttpHandlerWithServletSupport
implements HttpHandler {
    private HttpServlet servlet;

    public HttpHandlerWithServletSupport(HttpServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public void handle(HttpExchange ex) throws IOException {
        byte[] inBytes = HttpHandlerWithServletSupport.getBytes(ex.getRequestBody());
        ex.getRequestBody().close();
        final ByteArrayInputStream newInput = new ByteArrayInputStream(inBytes);
        ServletInputStream is = new ServletInputStream(){

            public int read() throws IOException {
                return newInput.read();
            }

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
        HashMap parsePostData = new HashMap();
        try {
            parsePostData.putAll(HttpUtils.parseQueryString((String)ex.getRequestURI().getQuery()));
            parsePostData.putAll(HttpUtils.parsePostData((int)inBytes.length, (ServletInputStream)is));
        }
        catch (IllegalArgumentException e) {
            newInput.reset();
        }
        HashMap postData = parsePostData;
        RequestWrapper req = new RequestWrapper(HttpHandlerWithServletSupport.createUnimplementAdapter(HttpServletRequest.class), ex, postData, is);
        ResponseWrapper resp = new ResponseWrapper(HttpHandlerWithServletSupport.createUnimplementAdapter(HttpServletResponse.class), ex);
        try {
            this.servlet.service((ServletRequest)req, (ServletResponse)resp);
            resp.complete();
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((r = in.read(buffer)) != -1) {
            out.write(buffer, 0, r);
        }
        return out.toByteArray();
    }

    private static <T> T createUnimplementAdapter(Class<T> httpServletApi) {
        class UnimplementedHandler
        implements InvocationHandler {
            UnimplementedHandler() {
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("Not implemented: " + method + ", args=" + Arrays.toString(args));
            }
        }
        return (T)Proxy.newProxyInstance(UnimplementedHandler.class.getClassLoader(), new Class[]{httpServletApi}, (InvocationHandler)new UnimplementedHandler());
    }

    private final class ResponseWrapper
    extends HttpServletResponseWrapper {
        final ByteArrayOutputStream outputStream;
        final ServletOutputStream servletOutputStream;
        private final HttpExchange ex;
        private final PrintWriter printWriter;
        private int status;

        private ResponseWrapper(HttpServletResponse response, HttpExchange ex) {
            super(response);
            this.outputStream = new ByteArrayOutputStream();
            this.servletOutputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ResponseWrapper.this.outputStream.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
            this.status = 200;
            this.ex = ex;
            this.printWriter = new PrintWriter((OutputStream)this.servletOutputStream);
        }

        public void setContentType(String type) {
            this.ex.getResponseHeaders().add("Content-Type", type);
        }

        public void setHeader(String name, String value) {
            this.ex.getResponseHeaders().add(name, value);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.servletOutputStream;
        }

        public void setContentLength(int len) {
            this.ex.getResponseHeaders().add("Content-Length", len + "");
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void sendError(int sc, String msg) throws IOException {
            this.status = sc;
            if (msg != null) {
                this.printWriter.write(msg);
            }
        }

        public void sendError(int sc) throws IOException {
            this.sendError(sc, null);
        }

        public PrintWriter getWriter() throws IOException {
            return this.printWriter;
        }

        public void addCookie(Cookie c) {
            Headers header = this.ex.getResponseHeaders();
            header.add("Set-Cookie", c.getName() + "=" + c.getValue());
        }

        public void complete() throws IOException {
            try {
                this.printWriter.flush();
                this.ex.sendResponseHeaders(this.status, this.outputStream.size());
                if (this.outputStream.size() > 0) {
                    this.ex.getResponseBody().write(this.outputStream.toByteArray());
                }
                this.ex.getResponseBody().flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.ex.close();
            }
        }
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpExchange ex;
        private final Map<String, String[]> postData;
        private final ServletInputStream is;
        private final Map<String, Object> attributes;

        private RequestWrapper(HttpServletRequest request, HttpExchange ex, Map<String, String[]> postData, ServletInputStream is) {
            super(request);
            this.attributes = new HashMap<String, Object>();
            this.ex = ex;
            this.postData = postData;
            this.is = is;
        }

        public Cookie[] getCookies() {
            Object strCookies;
            Headers headers = this.ex.getRequestHeaders();
            if (headers != null && (strCookies = headers.get("Cookie")) != null) {
                ArrayList<Cookie> cookies = new ArrayList<Cookie>();
                Iterator iterator = strCookies.iterator();
                while (iterator.hasNext()) {
                    String[] tokens;
                    String cookieString = (String)iterator.next();
                    for (String token : tokens = cookieString.split("\\s*;\\s*")) {
                        String[] keyVal = token.split("\\s*=\\s*");
                        if (keyVal.length != 2) continue;
                        cookies.add(new Cookie(keyVal[0], keyVal[1]));
                    }
                }
                return cookies.toArray(new Cookie[0]);
            }
            return null;
        }

        public String getHeader(String name) {
            return this.ex.getRequestHeaders().getFirst(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return new Vector(this.ex.getRequestHeaders().get(name)).elements();
        }

        public Enumeration<String> getHeaderNames() {
            return new Vector<String>(this.ex.getRequestHeaders().keySet()).elements();
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void setAttribute(String name, Object o) {
            this.attributes.put(name, o);
        }

        public Enumeration<String> getAttributeNames() {
            return new Vector<String>(this.attributes.keySet()).elements();
        }

        public String getMethod() {
            return this.ex.getRequestMethod();
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.is;
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }

        public String getPathInfo() {
            return this.ex.getRequestURI().getPath();
        }

        public String getParameter(String name) {
            Object[] arr = this.postData.get(name);
            return arr != null ? (arr.length > 1 ? Arrays.toString(arr) : arr[0]) : null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.postData;
        }

        public Enumeration<String> getParameterNames() {
            return new Vector<String>(this.postData.keySet()).elements();
        }
    }
}

