/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;

public class HystrixCodaHaleMetricsPublisherCommand
implements HystrixMetricsPublisherCommand {
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final MetricRegistry metricRegistry;
    private final String metricGroup;
    private final String metricType;

    public HystrixCodaHaleMetricsPublisherCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties, MetricRegistry metricRegistry) {
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.metricGroup = "HystrixCommand";
        this.metricType = this.key.name();
    }

    public void initialize() {
        this.metricRegistry.register(this.createMetricName("isCircuitBreakerOpen"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.circuitBreaker.isOpen();
            }
        });
        this.metricRegistry.register(this.createMetricName("currentTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis();
            }
        });
        this.createCumulativeCountForEvent("countCollapsedRequests", HystrixRollingNumberEvent.COLLAPSED);
        this.createCumulativeCountForEvent("countExceptionsThrown", HystrixRollingNumberEvent.EXCEPTION_THROWN);
        this.createCumulativeCountForEvent("countFailure", HystrixRollingNumberEvent.FAILURE);
        this.createCumulativeCountForEvent("countFallbackFailure", HystrixRollingNumberEvent.FALLBACK_FAILURE);
        this.createCumulativeCountForEvent("countFallbackRejection", HystrixRollingNumberEvent.FALLBACK_REJECTION);
        this.createCumulativeCountForEvent("countFallbackSuccess", HystrixRollingNumberEvent.FALLBACK_SUCCESS);
        this.createCumulativeCountForEvent("countResponsesFromCache", HystrixRollingNumberEvent.RESPONSE_FROM_CACHE);
        this.createCumulativeCountForEvent("countSemaphoreRejected", HystrixRollingNumberEvent.SEMAPHORE_REJECTED);
        this.createCumulativeCountForEvent("countShortCircuited", HystrixRollingNumberEvent.SHORT_CIRCUITED);
        this.createCumulativeCountForEvent("countSuccess", HystrixRollingNumberEvent.SUCCESS);
        this.createCumulativeCountForEvent("countThreadPoolRejected", HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
        this.createCumulativeCountForEvent("countTimeout", HystrixRollingNumberEvent.TIMEOUT);
        this.createRollingCountForEvent("rollingCountCollapsedRequests", HystrixRollingNumberEvent.COLLAPSED);
        this.createRollingCountForEvent("rollingCountExceptionsThrown", HystrixRollingNumberEvent.EXCEPTION_THROWN);
        this.createRollingCountForEvent("rollingCountFailure", HystrixRollingNumberEvent.FAILURE);
        this.createRollingCountForEvent("rollingCountFallbackFailure", HystrixRollingNumberEvent.FALLBACK_FAILURE);
        this.createRollingCountForEvent("rollingCountFallbackRejection", HystrixRollingNumberEvent.FALLBACK_REJECTION);
        this.createRollingCountForEvent("rollingCountFallbackSuccess", HystrixRollingNumberEvent.FALLBACK_SUCCESS);
        this.createRollingCountForEvent("rollingCountResponsesFromCache", HystrixRollingNumberEvent.RESPONSE_FROM_CACHE);
        this.createRollingCountForEvent("rollingCountSemaphoreRejected", HystrixRollingNumberEvent.SEMAPHORE_REJECTED);
        this.createRollingCountForEvent("rollingCountShortCircuited", HystrixRollingNumberEvent.SHORT_CIRCUITED);
        this.createRollingCountForEvent("rollingCountSuccess", HystrixRollingNumberEvent.SUCCESS);
        this.createRollingCountForEvent("rollingCountThreadPoolRejected", HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
        this.createRollingCountForEvent("rollingCountTimeout", HystrixRollingNumberEvent.TIMEOUT);
        this.metricRegistry.register(this.createMetricName("executionSemaphorePermitsInUse"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
            }
        });
        this.metricRegistry.register(this.createMetricName("errorPercentage"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_5"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(5.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyExecute_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_mean"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_5"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(5.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_25"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(25.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_50"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(50.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_75"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(75.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_90"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(90.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_99"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.0);
            }
        });
        this.metricRegistry.register(this.createMetricName("latencyTotal_percentile_995"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.5);
            }
        });
        this.metricRegistry.register(this.createMetricName("commandGroup"), (Metric)new Gauge<String>(){

            public String getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.commandGroupKey != null ? HystrixCodaHaleMetricsPublisherCommand.this.commandGroupKey.name() : null;
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_rollingStatisticalWindowInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerRequestVolumeThreshold"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerSleepWindowInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerErrorThresholdPercentage"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerForceOpen"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_circuitBreakerForceClosed"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationThreadTimeoutInMilliseconds"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionIsolationThreadTimeoutInMilliseconds().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationStrategy"), (Metric)new Gauge<String>(){

            public String getValue() {
                return ((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionIsolationStrategy().get()).name();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_metricsRollingPercentileEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.metricsRollingPercentileEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_requestCacheEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.requestCacheEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_requestLogEnabled"), (Metric)new Gauge<Boolean>(){

            public Boolean getValue() {
                return (Boolean)HystrixCodaHaleMetricsPublisherCommand.this.properties.requestLogEnabled().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        this.metricRegistry.register(this.createMetricName("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
    }

    protected String createMetricName(String name) {
        return MetricRegistry.name((String)this.metricGroup, (String[])new String[]{this.metricType, name});
    }

    protected void createCumulativeCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getCumulativeCount(event);
            }
        });
    }

    protected void createRollingCountForEvent(String name, final HystrixRollingNumberEvent event) {
        this.metricRegistry.register(this.createMetricName(name), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return HystrixCodaHaleMetricsPublisherCommand.this.metrics.getRollingCount(event);
            }
        });
    }
}

