/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command.closure;

import com.google.common.base.Throwables;
import com.netflix.hystrix.contrib.javanica.command.ClosureCommand;
import com.netflix.hystrix.contrib.javanica.command.closure.Closure;
import com.netflix.hystrix.contrib.javanica.command.closure.ClosureFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractClosureFactory
implements ClosureFactory {
    static final String ERROR_TYPE_MESSAGE = "return type of '{}' method should be {}.";
    static final String INVOKE_METHOD = "invoke";

    @Override
    public Closure createClosure(Method method, Object o, Object ... args) {
        try {
            Object closureObj = method.invoke(o, args);
            return this.createClosure(method.getName(), closureObj);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    Closure createClosure(String rootMethodName, Object closureObj) throws Exception {
        if (!this.isClosureCommand(closureObj)) {
            throw new RuntimeException(MessageFormatter.format((String)ERROR_TYPE_MESSAGE, (Object)rootMethodName, (Object)this.getClosureCommandType().getName()).getMessage());
        }
        Method closureMethod = closureObj.getClass().getMethod(INVOKE_METHOD, new Class[0]);
        return new Closure(closureMethod, closureObj);
    }

    abstract boolean isClosureCommand(Object var1);

    abstract Class<? extends ClosureCommand> getClosureCommandType();
}

