/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.aop.aspectj;

import com.google.common.collect.ImmutableMap;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.collapser.CommandCollapser;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutor;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericHystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class HystrixCommandAspect {
    private static final Map<HystrixPointcutType, MetaHolderFactory> META_HOLDER_FACTORY_MAP = ImmutableMap.builder().put((Object)HystrixPointcutType.COMMAND, (Object)new CommandMetaHolderFactory()).put((Object)HystrixPointcutType.COLLAPSER, (Object)new CollapserMetaHolderFactory()).build();

    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand)")
    public void hystrixCommandAnnotationPointcut() {
    }

    @Pointcut(value="@annotation(com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser)")
    public void hystrixCollapserAnnotationPointcut() {
    }

    @Around(value="hystrixCommandAnnotationPointcut() || hystrixCollapserAnnotationPointcut()")
    public Object methodsAnnotatedWithHystrixCommand(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        Validate.notNull((Object)method, (String)"failed to get method from joinPoint: %s", (Object[])new Object[]{joinPoint});
        if (method.isAnnotationPresent(HystrixCommand.class) && method.isAnnotationPresent(HystrixCollapser.class)) {
            throw new IllegalStateException("method cannot be annotated with HystrixCommand and HystrixCollapser annotations at the same time");
        }
        MetaHolderFactory metaHolderFactory = META_HOLDER_FACTORY_MAP.get((Object)HystrixPointcutType.of(method));
        MetaHolder metaHolder = metaHolderFactory.create(joinPoint);
        ExecutionType executionType = metaHolder.isCollapser() ? metaHolder.getCollapserExecutionType() : metaHolder.getExecutionType();
        Object executable = metaHolder.isCollapser() ? new CommandCollapser(metaHolder) : GenericHystrixCommandFactory.getInstance().create(metaHolder, null);
        try {
            result = CommandExecutor.execute((HystrixExecutable)executable, executionType);
        }
        catch (HystrixBadRequestException e) {
            throw e.getCause();
        }
        return result;
    }

    private static enum HystrixPointcutType {
        COMMAND,
        COLLAPSER;


        static HystrixPointcutType of(Method method) {
            return method.isAnnotationPresent(HystrixCommand.class) ? COMMAND : COLLAPSER;
        }
    }

    private static class CommandMetaHolderFactory
    extends MetaHolderFactory {
        private CommandMetaHolderFactory() {
        }

        @Override
        public MetaHolder create(Object proxy, Method method, Object obj, Object[] args) {
            HystrixCommand hystrixCommand = method.getAnnotation(HystrixCommand.class);
            MetaHolder.Builder builder = this.metaHolderBuilder(proxy, method, obj, args);
            builder.defaultCommandKey(method.getName());
            builder.hystrixCommand(hystrixCommand);
            builder.executionType(ExecutionType.getExecutionType(method.getReturnType()));
            return builder.build();
        }
    }

    private static class CollapserMetaHolderFactory
    extends MetaHolderFactory {
        private CollapserMetaHolderFactory() {
        }

        @Override
        public MetaHolder create(Object proxy, Method collapserMethod, Object obj, Object[] args) {
            HystrixCollapser hystrixCollapser = collapserMethod.getAnnotation(HystrixCollapser.class);
            Method batchCommandMethod = AopUtils.getDeclaredMethod(obj.getClass(), hystrixCollapser.batchMethod(), List.class);
            if (batchCommandMethod == null || !batchCommandMethod.getReturnType().equals(List.class)) {
                throw new IllegalStateException("required batch method for collapser is absent: (java.util.List) " + obj.getClass().getCanonicalName() + "." + hystrixCollapser.batchMethod() + "(java.util.List)");
            }
            HystrixCommand hystrixCommand = batchCommandMethod.getAnnotation(HystrixCommand.class);
            if (hystrixCommand == null) {
                throw new IllegalStateException("batch method must be annotated with HystrixCommand annotation");
            }
            MetaHolder.Builder builder = this.metaHolderBuilder(proxy, batchCommandMethod, obj, args);
            builder.hystrixCollapser(hystrixCollapser);
            builder.defaultCollapserKey(collapserMethod.getName());
            builder.collapserExecutionType(ExecutionType.getExecutionType(collapserMethod.getReturnType()));
            builder.defaultCommandKey(batchCommandMethod.getName());
            builder.hystrixCommand(hystrixCommand);
            builder.executionType(ExecutionType.getExecutionType(batchCommandMethod.getReturnType()));
            return builder.build();
        }
    }

    private static abstract class MetaHolderFactory {
        private MetaHolderFactory() {
        }

        public MetaHolder create(ProceedingJoinPoint joinPoint) {
            Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
            Object obj = joinPoint.getTarget();
            Object[] args = joinPoint.getArgs();
            Object proxy = joinPoint.getThis();
            return this.create(proxy, method, obj, args);
        }

        public abstract MetaHolder create(Object var1, Method var2, Object var3, Object[] var4);

        MetaHolder.Builder metaHolderBuilder(Object proxy, Method method, Object obj, Object[] args) {
            return MetaHolder.builder().args(args).method(method).obj(obj).proxyObj(proxy).defaultGroupKey(obj.getClass().getSimpleName());
        }
    }
}

