/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContext;
import com.netflix.hystrix.contrib.javanica.cache.HystrixCacheKeyGenerator;
import com.netflix.hystrix.contrib.javanica.cache.HystrixGeneratedCacheKey;
import com.netflix.hystrix.contrib.javanica.cache.HystrixRequestCacheManager;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheRemove;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheResult;
import com.netflix.hystrix.contrib.javanica.command.AbstractHystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import com.netflix.hystrix.contrib.javanica.exception.FallbackInvocationException;
import com.netflix.hystrix.contrib.javanica.utils.CommonUtils;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

@ThreadSafe
public class GenericObservableCommand
extends HystrixObservableCommand {
    private final CommandActions commandActions;
    private final CacheInvocationContext<CacheResult> cacheResultInvocationContext;
    private final CacheInvocationContext<CacheRemove> cacheRemoveInvocationContext;
    private final List<Class<? extends Throwable>> ignoreExceptions;
    private final ExecutionType executionType;
    private final HystrixCacheKeyGenerator defaultCacheKeyGenerator = HystrixCacheKeyGenerator.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericObservableCommand.class);

    public GenericObservableCommand(HystrixCommandBuilder builder) {
        super(builder.getSetterBuilder().buildObservableCommandSetter());
        this.commandActions = builder.getCommandActions();
        this.cacheResultInvocationContext = builder.getCacheResultInvocationContext();
        this.cacheRemoveInvocationContext = builder.getCacheRemoveInvocationContext();
        this.ignoreExceptions = builder.getIgnoreExceptions();
        this.executionType = builder.getExecutionType();
    }

    protected Observable construct() {
        Observable result;
        try {
            result = (Observable)this.commandActions.getCommandAction().execute(this.executionType);
            this.flushCache();
        }
        catch (CommandActionExecutionException throwable) {
            Throwable cause = throwable.getCause();
            if (this.isIgnorable(cause)) {
                throw new HystrixBadRequestException(cause.getMessage(), cause);
            }
            throw throwable;
        }
        return result;
    }

    protected Observable resumeWithFallback() {
        if (this.commandActions.hasFallbackAction()) {
            MetaHolder metaHolder = this.commandActions.getFallbackAction().getMetaHolder();
            Throwable cause = this.getExecutionException();
            if (cause instanceof CommandActionExecutionException) {
                cause = cause.getCause();
            }
            Object[] args = CommonUtils.createArgsForFallback(metaHolder, cause);
            try {
                Object res = this.commandActions.getFallbackAction().executeWithArgs(this.executionType, args);
                if (res instanceof Observable) {
                    return (Observable)res;
                }
                return Observable.just((Object)res);
            }
            catch (Exception e) {
                LOGGER.error(AbstractHystrixCommand.FallbackErrorMessageBuilder.create().append(this.commandActions.getFallbackAction(), e).build());
                throw new FallbackInvocationException(e.getCause());
            }
        }
        return super.resumeWithFallback();
    }

    protected String getCacheKey() {
        String key = null;
        if (this.cacheResultInvocationContext != null) {
            HystrixGeneratedCacheKey hystrixGeneratedCacheKey = this.defaultCacheKeyGenerator.generateCacheKey(this.cacheResultInvocationContext);
            key = hystrixGeneratedCacheKey.getCacheKey();
        }
        return key;
    }

    protected void flushCache() {
        if (this.cacheRemoveInvocationContext != null) {
            HystrixRequestCacheManager.getInstance().clearCache(this.cacheRemoveInvocationContext);
        }
    }

    boolean isIgnorable(Throwable throwable) {
        if (this.ignoreExceptions == null || this.ignoreExceptions.isEmpty()) {
            return false;
        }
        for (Class<? extends Throwable> ignoreException : this.ignoreExceptions) {
            if (!ignoreException.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }
}

