/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.base.Optional;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.exception.FallbackDefinitionException;
import com.netflix.hystrix.contrib.javanica.utils.FallbackMethod;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public final class MethodProvider {
    private static final MethodProvider INSTANCE = new MethodProvider();
    private Map<Method, Method> cache = new ConcurrentHashMap<Method, Method>();

    private MethodProvider() {
    }

    public static MethodProvider getInstance() {
        return INSTANCE;
    }

    public FallbackMethod getFallbackMethod(Class<?> type, Method commandMethod) {
        return this.getFallbackMethod(type, commandMethod, false);
    }

    public FallbackMethod getFallbackMethod(Class<?> type, Method commandMethod, boolean extended) {
        HystrixCommand hystrixCommand;
        if (commandMethod.isAnnotationPresent(HystrixCommand.class) && StringUtils.isNotBlank((CharSequence)(hystrixCommand = commandMethod.getAnnotation(HystrixCommand.class)).fallbackMethod())) {
            Optional<Method> fMethod;
            Object[] parameterTypes = commandMethod.getParameterTypes();
            if (extended && parameterTypes[parameterTypes.length - 1] == Throwable.class) {
                parameterTypes = (Class[])ArrayUtils.remove((Object[])parameterTypes, (int)(parameterTypes.length - 1));
            }
            Class<?>[] exParameterTypes = Arrays.copyOf(parameterTypes, parameterTypes.length + 1);
            exParameterTypes[parameterTypes.length] = Throwable.class;
            Optional<Method> exFallbackMethod = this.getMethod(type, hystrixCommand.fallbackMethod(), exParameterTypes);
            Method method = (Method)exFallbackMethod.or(fMethod = this.getMethod(type, hystrixCommand.fallbackMethod(), (Class<?>[])parameterTypes)).orNull();
            if (method == null) {
                throw new FallbackDefinitionException("fallback method wasn't found: " + hystrixCommand.fallbackMethod() + "(" + Arrays.toString(parameterTypes) + ")");
            }
            return new FallbackMethod(method, exFallbackMethod.isPresent());
        }
        return FallbackMethod.ABSENT;
    }

    public Optional<Method> getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return Optional.of((Object)type.getDeclaredMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    public Method unbride(final Method bridgeMethod, Class<?> aClass) throws IOException, NoSuchMethodException, ClassNotFoundException {
        if (bridgeMethod.isBridge() && bridgeMethod.isSynthetic()) {
            if (this.cache.containsKey(bridgeMethod)) {
                return this.cache.get(bridgeMethod);
            }
            ClassReader classReader = new ClassReader(aClass.getName());
            final MethodSignature methodSignature = new MethodSignature();
            classReader.accept(new ClassVisitor(327680){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    boolean bridge;
                    boolean bl = bridge = (access & 0x40) != 0 && (access & 0x1000) != 0;
                    if (bridge && bridgeMethod.getName().equals(name) && MethodProvider.getParameterCount(desc) == bridgeMethod.getParameterTypes().length) {
                        return new MethodFinder(methodSignature);
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            }, 0);
            Method method = aClass.getDeclaredMethod(methodSignature.name, methodSignature.getParameterTypes());
            this.cache.put(bridgeMethod, method);
            return method;
        }
        return bridgeMethod;
    }

    private static int getParameterCount(String desc) {
        return MethodProvider.parseParams(desc).length;
    }

    private static String[] parseParams(String desc) {
        String params = desc.split("\\)")[0].replace("(", "");
        if (params.length() == 0) {
            return new String[0];
        }
        return params.split(";");
    }

    private static class MethodFinder
    extends MethodVisitor {
        private MethodSignature methodSignature;

        public MethodFinder(MethodSignature methodSignature) {
            super(327680);
            this.methodSignature = methodSignature;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.methodSignature.name = name;
            this.methodSignature.desc = desc;
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class MethodSignature {
        String name;
        String desc;

        private MethodSignature() {
        }

        public Class<?>[] getParameterTypes() throws ClassNotFoundException {
            if (this.desc == null) {
                return new Class[0];
            }
            String[] params = MethodProvider.parseParams(this.desc);
            Class[] parameterTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                String arg = params[i].substring(1).replace("/", ".");
                parameterTypes[i] = Class.forName(arg);
            }
            return parameterTypes;
        }
    }
}

