/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.exception.FallbackDefinitionException;
import com.netflix.hystrix.contrib.javanica.utils.TypeHelper;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FallbackMethod {
    private final Method method;
    private final boolean extended;
    private ExecutionType executionType;
    public static final FallbackMethod ABSENT = new FallbackMethod(null, false);

    public FallbackMethod(Method method) {
        this(method, false);
    }

    public FallbackMethod(Method method, boolean extended) {
        this.method = method;
        this.extended = extended;
        if (method != null) {
            this.executionType = ExecutionType.getExecutionType(method.getReturnType());
        }
    }

    public boolean isCommand() {
        return this.method.isAnnotationPresent(HystrixCommand.class);
    }

    public boolean isPresent() {
        return this.method != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void validateReturnType(Method commandMethod) {
        if (this.isPresent()) {
            Class<?> commandReturnType = commandMethod.getReturnType();
            if (ExecutionType.OBSERVABLE == ExecutionType.getExecutionType(commandReturnType)) {
                if (ExecutionType.OBSERVABLE != this.getExecutionType()) {
                    Type commandParametrizedType = commandMethod.getGenericReturnType();
                    if (TypeHelper.isReturnTypeParametrized(commandMethod)) {
                        commandParametrizedType = this.getFirstParametrizedType(commandMethod);
                    }
                    this.validateParametrizedType(commandParametrizedType, this.method.getGenericReturnType(), commandMethod, this.method);
                } else {
                    this.validateReturnType(commandMethod, this.method);
                }
            } else if (ExecutionType.ASYNCHRONOUS == ExecutionType.getExecutionType(commandReturnType)) {
                if (this.isCommand() && ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    this.validateReturnType(commandMethod, this.method);
                }
                if (ExecutionType.ASYNCHRONOUS != this.getExecutionType()) {
                    Type commandParametrizedType = commandMethod.getGenericReturnType();
                    if (TypeHelper.isReturnTypeParametrized(commandMethod)) {
                        commandParametrizedType = this.getFirstParametrizedType(commandMethod);
                    }
                    this.validateParametrizedType(commandParametrizedType, this.method.getGenericReturnType(), commandMethod, this.method);
                }
                if (!this.isCommand() && ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Future if the fallback isn't command when the command is async."));
                }
            } else {
                if (ExecutionType.ASYNCHRONOUS == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Future if command isn't asynchronous."));
                }
                if (ExecutionType.OBSERVABLE == this.getExecutionType()) {
                    throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, "fallback cannot return Observable if command isn't observable."));
                }
                this.validateReturnType(commandMethod, this.method);
            }
        }
    }

    private Type getFirstParametrizedType(Method m) {
        Type gtype = m.getGenericReturnType();
        if (gtype instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gtype;
            return pType.getActualTypeArguments()[0];
        }
        return null;
    }

    private void validateReturnType(Method commandMethod, Method fallbackMethod) {
        List<Type> fallbackParametrizedTypes;
        List<Type> commandParametrizedTypes;
        List<String> msg;
        if (TypeHelper.isReturnTypeParametrized(commandMethod) && !(msg = this.equalsParametrizedTypes(commandParametrizedTypes = this.getParametrizedTypes(commandMethod), fallbackParametrizedTypes = this.getParametrizedTypes(fallbackMethod))).isEmpty()) {
            throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, this.method, StringUtils.join(msg, (String)", ")));
        }
        this.validatePlainReturnType(commandMethod, fallbackMethod);
    }

    private void validatePlainReturnType(Method commandMethod, Method fallbackMethod) {
        this.validatePlainReturnType(commandMethod.getReturnType(), fallbackMethod.getReturnType(), commandMethod, fallbackMethod);
    }

    private void validatePlainReturnType(Class<?> commandReturnType, Class<?> fallbackReturnType, Method commandMethod, Method fallbackMethod) {
        if (!commandReturnType.isAssignableFrom(fallbackReturnType)) {
            throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, fallbackMethod, "Fallback method '" + fallbackMethod + "' must return: " + commandReturnType + " or it's subclass"));
        }
    }

    private void validateParametrizedType(Type commandReturnType, Type fallbackReturnType, Method commandMethod, Method fallbackMethod) {
        if (!commandReturnType.equals(fallbackReturnType)) {
            throw new FallbackDefinitionException(this.createErrorMsg(commandMethod, fallbackMethod, "Fallback method '" + fallbackMethod + "' must return: " + commandReturnType + " or it's subclass"));
        }
    }

    private String createErrorMsg(Method commandMethod, Method fallbackMethod, String hint) {
        return "Incompatible return types. Command method: " + commandMethod + ", fallback method: " + fallbackMethod + ". " + (StringUtils.isNotBlank((CharSequence)hint) ? "Hint: " : "");
    }

    private List<Type> getParametrizedTypes(Method m) {
        return TypeHelper.getAllParameterizedTypes(m.getGenericReturnType());
    }

    private List<String> equalsParametrizedTypes(List<Type> commandParametrizedTypes, List<Type> fallbackParametrizedTypes) {
        List<String> msg = Collections.emptyList();
        if (commandParametrizedTypes.size() != fallbackParametrizedTypes.size()) {
            return Collections.singletonList("a different set of parametrized types, command: " + commandParametrizedTypes.size() + " fallback: " + fallbackParametrizedTypes.size());
        }
        for (int i = 0; i < commandParametrizedTypes.size(); ++i) {
            Type fallbackParametrizedType;
            Type commandParametrizedType = commandParametrizedTypes.get(i);
            if (commandParametrizedType.equals(fallbackParametrizedType = fallbackParametrizedTypes.get(i))) continue;
            if (Collections.emptyList() == msg) {
                msg = new ArrayList<String>();
            }
            msg.add("wrong parametrized type. Expected: '" + commandParametrizedType + "' but in fallback '" + fallbackParametrizedType + "', position: " + i);
            return msg;
        }
        return msg;
    }
}

