/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationContextFactory;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandActions;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.GenericSetterBuilder;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandBuilder;
import com.netflix.hystrix.contrib.javanica.command.LazyCommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import com.netflix.hystrix.contrib.javanica.utils.EnvUtils;
import com.netflix.hystrix.contrib.javanica.utils.FallbackMethod;
import com.netflix.hystrix.contrib.javanica.utils.MethodProvider;
import com.netflix.hystrix.contrib.javanica.utils.ajc.AjcUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Validate;

public class HystrixCommandBuilderFactory {
    private static final HystrixCommandBuilderFactory INSTANCE = new HystrixCommandBuilderFactory();

    public static HystrixCommandBuilderFactory getInstance() {
        return INSTANCE;
    }

    private HystrixCommandBuilderFactory() {
    }

    public HystrixCommandBuilder create(MetaHolder metaHolder) {
        return this.create(metaHolder, Collections.emptyList());
    }

    public <ResponseType> HystrixCommandBuilder create(MetaHolder metaHolder, Collection<HystrixCollapser.CollapsedRequest<ResponseType, Object>> collapsedRequests) {
        this.validateMetaHolder(metaHolder);
        return HystrixCommandBuilder.builder().setterBuilder(this.createGenericSetterBuilder(metaHolder)).commandActions(this.createCommandActions(metaHolder)).collapsedRequests(collapsedRequests).cacheResultInvocationContext(CacheInvocationContextFactory.createCacheResultInvocationContext(metaHolder)).cacheRemoveInvocationContext(CacheInvocationContextFactory.createCacheRemoveInvocationContext(metaHolder)).ignoreExceptions(metaHolder.getCommandIgnoreExceptions()).executionType(metaHolder.getExecutionType()).build();
    }

    private void validateMetaHolder(MetaHolder metaHolder) {
        Validate.notNull((Object)metaHolder, (String)"metaHolder is required parameter and cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)metaHolder.isCommandAnnotationPresent(), (String)"hystrixCommand annotation is absent", (Object[])new Object[0]);
    }

    private GenericSetterBuilder createGenericSetterBuilder(MetaHolder metaHolder) {
        GenericSetterBuilder.Builder setterBuilder = GenericSetterBuilder.builder().groupKey(metaHolder.getCommandGroupKey()).threadPoolKey(metaHolder.getThreadPoolKey()).commandKey(metaHolder.getCommandKey()).collapserKey(metaHolder.getCollapserKey()).commandProperties(metaHolder.getCommandProperties()).threadPoolProperties(metaHolder.getThreadPoolProperties()).collapserProperties(metaHolder.getCollapserProperties());
        if (metaHolder.isCollapserAnnotationPresent()) {
            setterBuilder.scope(metaHolder.getHystrixCollapser().scope());
        }
        return setterBuilder.build();
    }

    private CommandActions createCommandActions(MetaHolder metaHolder) {
        CommandAction commandAction = this.createCommandAction(metaHolder);
        CommandAction fallbackAction = this.createFallbackAction(metaHolder);
        return CommandActions.builder().commandAction(commandAction).fallbackAction(fallbackAction).build();
    }

    private CommandAction createCommandAction(MetaHolder metaHolder) {
        return new MethodExecutionAction(metaHolder.getObj(), metaHolder.getMethod(), metaHolder.getArgs(), metaHolder);
    }

    private CommandAction createFallbackAction(MetaHolder metaHolder) {
        FallbackMethod fallbackMethod = MethodProvider.getInstance().getFallbackMethod(metaHolder.getObj().getClass(), metaHolder.getMethod(), metaHolder.isExtendedFallback());
        fallbackMethod.validateReturnType(metaHolder.getMethod());
        CommandAction fallbackAction = null;
        if (fallbackMethod.isPresent()) {
            Method fMethod = fallbackMethod.getMethod();
            if (fallbackMethod.isCommand()) {
                fMethod.setAccessible(true);
                HystrixCommand hystrixCommand = fMethod.getAnnotation(HystrixCommand.class);
                MetaHolder fmMetaHolder = MetaHolder.builder().obj(metaHolder.getObj()).method(fMethod).ajcMethod(this.getAjcMethod(metaHolder.getObj(), fMethod)).args(metaHolder.getArgs()).fallback(true).defaultCollapserKey(metaHolder.getDefaultCollapserKey()).fallbackMethod(fMethod).extendedFallback(fallbackMethod.isExtended()).fallbackExecutionType(fallbackMethod.getExecutionType()).extendedParentFallback(metaHolder.isExtendedFallback()).observable(ExecutionType.OBSERVABLE == fallbackMethod.getExecutionType()).defaultCommandKey(fMethod.getName()).defaultGroupKey(metaHolder.getDefaultGroupKey()).defaultThreadPoolKey(metaHolder.getDefaultThreadPoolKey()).defaultProperties((DefaultProperties)metaHolder.getDefaultProperties().orNull()).hystrixCollapser(metaHolder.getHystrixCollapser()).observableExecutionMode(hystrixCommand.observableExecutionMode()).hystrixCommand(hystrixCommand).build();
                fallbackAction = new LazyCommandExecutionAction(fmMetaHolder);
            } else {
                MetaHolder fmMetaHolder = MetaHolder.builder().obj(metaHolder.getObj()).method(fMethod).fallbackExecutionType(ExecutionType.SYNCHRONOUS).extendedFallback(fallbackMethod.isExtended()).extendedParentFallback(metaHolder.isExtendedFallback()).ajcMethod(null).args(metaHolder.getArgs()).build();
                fallbackAction = new MethodExecutionAction(fmMetaHolder.getObj(), fMethod, fmMetaHolder.getArgs(), fmMetaHolder);
            }
        }
        return fallbackAction;
    }

    private Method getAjcMethod(Object target, Method fallback) {
        if (EnvUtils.isCompileWeaving()) {
            return AjcUtils.getAjcMethodAroundAdvice(target.getClass(), fallback);
        }
        return null;
    }
}

