/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.metrics.eventstream;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixMetricsPoller {
    static final Logger logger = LoggerFactory.getLogger(HystrixMetricsPoller.class);
    private final ScheduledExecutorService executor;
    private final int delay;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final int BATCH_SIZE = 10;

    public HystrixMetricsPoller(int delay) {
        this.executor = new ScheduledThreadPoolExecutor(1, new MetricsPollerThreadFactory());
        this.delay = delay;
    }

    public synchronized void start(HttpServletResponse httpResponse) {
        logger.info("Starting HystrixMetricsPoller");
        this.executor.scheduleWithFixedDelay(new MetricsPoller(httpResponse), 0L, this.delay, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        logger.info("Stopping the Servo Metrics Poller");
        this.running.set(false);
        this.executor.shutdownNow();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private class MetricsPollerThreadFactory
    implements ThreadFactory {
        private static final String MetricsThreadName = "ServoMetricPoller";
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private MetricsPollerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName(MetricsThreadName);
            return thread;
        }
    }

    private class MetricsPoller
    implements Runnable {
        private final HttpServletResponse httpResponse;
        private final JsonFactory jsonFactory = new JsonFactory();

        public MetricsPoller(HttpServletResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        @Override
        public void run() {
            try {
                HystrixCommandKey key;
                int flushCount = 0;
                for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
                    ++flushCount;
                    key = commandMetrics.getCommandKey();
                    HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key);
                    StringWriter jsonString = new StringWriter();
                    JsonGenerator json = this.jsonFactory.createJsonGenerator((Writer)jsonString);
                    json.writeStartObject();
                    json.writeStringField("type", "HystrixCommand");
                    json.writeStringField("name", key.name());
                    json.writeStringField("group", commandMetrics.getCommandGroup().name());
                    json.writeNumberField("currentTime", System.currentTimeMillis());
                    json.writeBooleanField("isCircuitBreakerOpen", circuitBreaker.isOpen());
                    HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
                    json.writeNumberField("errorPercentage", healthCounts.getErrorPercentage());
                    json.writeNumberField("errorCount", healthCounts.getErrorCount());
                    json.writeNumberField("requestCount", healthCounts.getTotalRequests());
                    json.writeNumberField("rollingCountCollapsedRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSED));
                    json.writeNumberField("rollingCountExceptionsThrown", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                    json.writeNumberField("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                    json.writeNumberField("rollingCountFallbackFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                    json.writeNumberField("rollingCountFallbackRejection", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                    json.writeNumberField("rollingCountFallbackSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                    json.writeNumberField("rollingCountResponsesFromCache", commandMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                    json.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                    json.writeNumberField("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                    json.writeNumberField("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                    json.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                    json.writeNumberField("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                    json.writeNumberField("currentConcurrentExecutionCount", commandMetrics.getCurrentConcurrentExecutionCount());
                    json.writeNumberField("latencyExecute_mean", commandMetrics.getExecutionTimeMean());
                    json.writeArrayFieldStart("latencyExecute");
                    json.writeStartObject();
                    json.writeNumberField("0", commandMetrics.getExecutionTimePercentile(0.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("25", commandMetrics.getExecutionTimePercentile(25.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("50", commandMetrics.getExecutionTimePercentile(50.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("75", commandMetrics.getExecutionTimePercentile(75.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("90", commandMetrics.getExecutionTimePercentile(90.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("95", commandMetrics.getExecutionTimePercentile(95.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("99", commandMetrics.getExecutionTimePercentile(99.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("99.5", commandMetrics.getExecutionTimePercentile(99.5));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("100", commandMetrics.getExecutionTimePercentile(100.0));
                    json.writeEndObject();
                    json.writeEndArray();
                    json.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
                    json.writeArrayFieldStart("latencyTotal");
                    json.writeStartObject();
                    json.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
                    json.writeEndObject();
                    json.writeStartObject();
                    json.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
                    json.writeEndObject();
                    json.writeEndArray();
                    HystrixCommandProperties commandProperties = commandMetrics.getProperties();
                    json.writeNumberField("propertyValue_circuitBreakerRequestVolumeThreshold", ((Integer)commandProperties.circuitBreakerRequestVolumeThreshold().get()).intValue());
                    json.writeNumberField("propertyValue_circuitBreakerSleepWindowInMilliseconds", ((Integer)commandProperties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
                    json.writeNumberField("propertyValue_circuitBreakerErrorThresholdPercentage", ((Integer)commandProperties.circuitBreakerErrorThresholdPercentage().get()).intValue());
                    json.writeBooleanField("propertyValue_circuitBreakerForceOpen", ((Boolean)commandProperties.circuitBreakerForceOpen().get()).booleanValue());
                    json.writeBooleanField("propertyValue_circuitBreakerForceClosed", ((Boolean)commandProperties.circuitBreakerForceClosed().get()).booleanValue());
                    json.writeBooleanField("propertyValue_circuitBreakerEnabled", ((Boolean)commandProperties.circuitBreakerEnabled().get()).booleanValue());
                    json.writeStringField("propertyValue_executionIsolationStrategy", ((HystrixCommandProperties.ExecutionIsolationStrategy)commandProperties.executionIsolationStrategy().get()).name());
                    json.writeNumberField("propertyValue_executionIsolationThreadTimeoutInMilliseconds", ((Integer)commandProperties.executionIsolationThreadTimeoutInMilliseconds().get()).intValue());
                    json.writeBooleanField("propertyValue_executionIsolationThreadInterruptOnTimeout", ((Boolean)commandProperties.executionIsolationThreadInterruptOnTimeout().get()).booleanValue());
                    json.writeStringField("propertyValue_executionIsolationThreadPoolKeyOverride", (String)commandProperties.executionIsolationThreadPoolKeyOverride().get());
                    json.writeNumberField("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
                    json.writeNumberField("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
                    json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)commandProperties.requestCacheEnabled().get()).booleanValue());
                    json.writeBooleanField("propertyValue_requestLogEnabled", ((Boolean)commandProperties.requestLogEnabled().get()).booleanValue());
                    json.writeEndObject();
                    json.close();
                    this.httpResponse.getWriter().println("data: " + jsonString.getBuffer().toString() + "\n");
                    if (flushCount != 10) continue;
                    flushCount = 0;
                    this.httpResponse.flushBuffer();
                }
                for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                    ++flushCount;
                    key = threadPoolMetrics.getThreadPoolKey();
                    StringWriter jsonString = new StringWriter();
                    JsonGenerator json = this.jsonFactory.createJsonGenerator((Writer)jsonString);
                    json.writeStartObject();
                    json.writeStringField("type", "HystrixThreadPool");
                    json.writeStringField("name", key.name());
                    json.writeNumberField("currentTime", System.currentTimeMillis());
                    json.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
                    json.writeNumberField("currentCompletedTaskCount", threadPoolMetrics.getCurrentCompletedTaskCount().longValue());
                    json.writeNumberField("currentCorePoolSize", threadPoolMetrics.getCurrentCorePoolSize().intValue());
                    json.writeNumberField("currentLargestPoolSize", threadPoolMetrics.getCurrentLargestPoolSize().intValue());
                    json.writeNumberField("currentMaximumPoolSize", threadPoolMetrics.getCurrentMaximumPoolSize().intValue());
                    json.writeNumberField("currentPoolSize", threadPoolMetrics.getCurrentPoolSize().intValue());
                    json.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
                    json.writeNumberField("currentTaskCount", threadPoolMetrics.getCurrentTaskCount().longValue());
                    json.writeNumberField("rollingCountThreadsExecuted", threadPoolMetrics.getRollingCountThreadsExecuted());
                    json.writeNumberField("rollingMaxActiveThreads", threadPoolMetrics.getRollingMaxActiveThreads());
                    json.writeEndObject();
                    json.close();
                    this.httpResponse.getWriter().println("data: " + jsonString.getBuffer().toString() + "\n");
                    if (flushCount != 10) continue;
                    flushCount = 0;
                    this.httpResponse.flushBuffer();
                }
                this.httpResponse.flushBuffer();
            }
            catch (SocketException e) {
                logger.debug("SocketException (most likely that client disconnected) while streaming metrics", (Throwable)e);
                HystrixMetricsPoller.this.stop();
                return;
            }
            catch (Exception e) {
                logger.warn("Failed to stream metrics", (Throwable)e);
                HystrixMetricsPoller.this.stop();
                return;
            }
        }
    }
}

