/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.metrics.eventstream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsPoller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixMetricsStreamServlet
extends HttpServlet {
    private static final long serialVersionUID = -7548505095303313237L;
    private static final Logger logger = LoggerFactory.getLogger(HystrixMetricsStreamServlet.class);
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.stream.maxConcurrentConnections", 5);
    private static volatile boolean isDestroyed = false;

    public static void shutdown() {
        isDestroyed = true;
    }

    public void init() throws ServletException {
        isDestroyed = false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void destroy() {
        isDestroyed = true;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block20: {
            int numberConnections = concurrentConnections.incrementAndGet();
            HystrixMetricsPoller poller = null;
            try {
                if (numberConnections > maxConcurrentConnections.get()) {
                    response.sendError(503, "MaxConcurrentConnections reached: " + maxConcurrentConnections.get());
                    break block20;
                }
                int delay = 500;
                try {
                    String d = request.getParameter("delay");
                    if (d != null) {
                        delay = Integer.parseInt(d);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                MetricJsonListener jsonListener = new MetricJsonListener();
                poller = new HystrixMetricsPoller(jsonListener, delay);
                poller.start();
                logger.info("Starting poller");
                try {
                    while (poller.isRunning() && !isDestroyed) {
                        List<String> jsonMessages = jsonListener.getJsonMetrics();
                        if (jsonMessages.isEmpty()) {
                            response.getWriter().println("ping: \n");
                        } else {
                            for (String json : jsonMessages) {
                                response.getWriter().println("data: " + json + "\n");
                            }
                        }
                        if (!isDestroyed) {
                            response.flushBuffer();
                            if (response.getWriter().checkError()) {
                                throw new IOException("io error");
                            }
                            Thread.sleep(delay);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    poller.shutdown();
                    logger.debug("InterruptedException. Will stop polling.");
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    poller.shutdown();
                    logger.debug("IOException while trying to write (generally caused by client disconnecting). Will stop polling.", (Throwable)e);
                }
                catch (Exception e) {
                    poller.shutdown();
                    logger.error("Failed to write. Will stop polling.", (Throwable)e);
                }
                logger.debug("Stopping Turbine stream to connection");
            }
            catch (Exception e) {
                logger.error("Error initializing servlet for metrics event stream.", (Throwable)e);
            }
            finally {
                concurrentConnections.decrementAndGet();
                if (poller != null) {
                    poller.shutdown();
                }
            }
        }
    }

    private static class MetricJsonListener
    implements HystrixMetricsPoller.MetricsAsJsonPollerListener {
        private final LinkedBlockingQueue<String> jsonMetrics = new LinkedBlockingQueue(1000);

        private MetricJsonListener() {
        }

        @Override
        public void handleJsonMetric(String json) {
            this.jsonMetrics.add(json);
        }

        public List<String> getJsonMetrics() {
            ArrayList<String> metrics = new ArrayList<String>();
            this.jsonMetrics.drainTo(metrics);
            return metrics;
        }
    }
}

