/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.sample.stream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.config.HystrixConfiguration;
import com.netflix.hystrix.contrib.sample.stream.HystrixConfigurationJsonStream;
import com.netflix.hystrix.contrib.sample.stream.HystrixSampleSseServlet;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.functions.Func1;

public class HystrixConfigSseServlet
extends HystrixSampleSseServlet<HystrixConfiguration> {
    private static final long serialVersionUID = -3599771169762858235L;
    private static final int DEFAULT_ONNEXT_DELAY_IN_MS = 10000;
    private final HystrixConfigurationJsonStream jsonStream;
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.config.stream.maxConcurrentConnections", 5);

    public HystrixConfigSseServlet() {
        this.jsonStream = new HystrixConfigurationJsonStream();
    }

    HystrixConfigSseServlet(Func1<Integer, Observable<HystrixConfiguration>> createStream) {
        this.jsonStream = new HystrixConfigurationJsonStream(createStream);
    }

    @Override
    int getDefaultDelayInMilliseconds() {
        return 10000;
    }

    @Override
    int getMaxNumberConcurrentConnectionsAllowed() {
        return maxConcurrentConnections.get();
    }

    @Override
    int getNumberCurrentConnections() {
        return concurrentConnections.get();
    }

    @Override
    protected int incrementAndGetCurrentConcurrentConnections() {
        return concurrentConnections.incrementAndGet();
    }

    @Override
    protected void decrementCurrentConcurrentConnections() {
        concurrentConnections.decrementAndGet();
    }

    @Override
    protected Observable<HystrixConfiguration> getStream(int delay) {
        return this.jsonStream.observe(delay);
    }

    @Override
    protected String convertToString(HystrixConfiguration config) throws IOException {
        return HystrixConfigurationJsonStream.convertToString(config);
    }
}

