/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.requests.stream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.contrib.requests.stream.HystrixRequestEventsJsonStream;
import com.netflix.hystrix.metric.HystrixRequestEvents;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public class HystrixRequestEventsSseServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestEventsSseServlet.class);
    private static volatile boolean isDestroyed = false;
    private static final String DELAY_REQ_PARAM_NAME = "delay";
    private static final int DEFAULT_DELAY_IN_MILLISECONDS = 10000;
    private static final int DEFAULT_QUEUE_DEPTH = 1000;
    private static final String PING = "\n: ping\n";
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.requests.stream.maxConcurrentConnections", 5);
    private final LinkedBlockingQueue<HystrixRequestEvents> requestQueue = new LinkedBlockingQueue(1000);
    private final HystrixRequestEventsJsonStream requestEventsJsonStream = new HystrixRequestEventsJsonStream();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDestroyed) {
            response.sendError(503, "Service has been shut down.");
        } else {
            this.handleRequest(request, response);
        }
    }

    int getDelayFromHttpRequest(HttpServletRequest req) {
        try {
            String delay = req.getParameter(DELAY_REQ_PARAM_NAME);
            if (delay != null) {
                return Math.max(Integer.parseInt(delay), 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 10000;
    }

    public static void shutdown() {
        isDestroyed = true;
    }

    public void init() throws ServletException {
        isDestroyed = false;
    }

    public void destroy() {
        isDestroyed = true;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block17: {
            final AtomicBoolean moreDataWillBeSent = new AtomicBoolean(true);
            Subscription requestsSubscription = null;
            int numberConnections = concurrentConnections.incrementAndGet();
            try {
                int maxNumberConnectionsAllowed = maxConcurrentConnections.get();
                if (numberConnections > maxNumberConnectionsAllowed) {
                    response.sendError(503, "MaxConcurrentConnections reached: " + maxNumberConnectionsAllowed);
                    break block17;
                }
                int delay = this.getDelayFromHttpRequest(request);
                response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                PrintWriter writer = response.getWriter();
                requestsSubscription = this.requestEventsJsonStream.getStream().observeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<HystrixRequestEvents>(){

                    public void onCompleted() {
                        logger.error("HystrixRequestEventsSseServlet received unexpected OnCompleted from request stream");
                        moreDataWillBeSent.set(false);
                    }

                    public void onError(Throwable e) {
                        moreDataWillBeSent.set(false);
                    }

                    public void onNext(HystrixRequestEvents requestEvents) {
                        if (requestEvents != null) {
                            HystrixRequestEventsSseServlet.this.requestQueue.offer(requestEvents);
                        }
                    }
                });
                while (moreDataWillBeSent.get() && !isDestroyed) {
                    try {
                        if (this.requestQueue.isEmpty()) {
                            try {
                                writer.print(PING);
                                writer.flush();
                            }
                            catch (Throwable t) {
                                throw new IOException("Exception while writing ping");
                            }
                            if (writer.checkError()) {
                                throw new IOException("io error");
                            }
                        } else {
                            ArrayList<HystrixRequestEvents> l = new ArrayList<HystrixRequestEvents>();
                            this.requestQueue.drainTo(l);
                            String requestEventsAsStr = HystrixRequestEventsJsonStream.convertRequestsToJson(l);
                            if (requestEventsAsStr != null) {
                                try {
                                    writer.print("data: " + requestEventsAsStr + "\n\n");
                                    if (writer.checkError()) {
                                        throw new IOException("io error");
                                    }
                                    writer.flush();
                                }
                                catch (IOException ioe) {
                                    moreDataWillBeSent.set(false);
                                }
                            }
                        }
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        moreDataWillBeSent.set(false);
                    }
                }
            }
            finally {
                concurrentConnections.decrementAndGet();
                if (requestsSubscription != null && !requestsSubscription.isUnsubscribed()) {
                    requestsSubscription.unsubscribe();
                }
            }
        }
    }
}

