/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.sample.stream;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public abstract class HystrixSampleSseServlet<SampleData>
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(HystrixSampleSseServlet.class);
    private static volatile boolean isDestroyed = false;
    private static final String DELAY_REQ_PARAM_NAME = "delay";

    abstract int getDefaultDelayInMilliseconds();

    abstract int getMaxNumberConcurrentConnectionsAllowed();

    abstract int getNumberCurrentConnections();

    protected abstract int incrementAndGetCurrentConcurrentConnections();

    protected abstract void decrementCurrentConcurrentConnections();

    protected abstract Observable<SampleData> getStream(int var1);

    protected abstract String convertToString(SampleData var1) throws IOException;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (isDestroyed) {
            response.sendError(503, "Service has been shut down.");
        } else {
            this.handleRequest(request, response);
        }
    }

    int getDelayFromHttpRequest(HttpServletRequest req) {
        try {
            String delay = req.getParameter(DELAY_REQ_PARAM_NAME);
            if (delay != null) {
                return Math.max(Integer.parseInt(delay), 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getDefaultDelayInMilliseconds();
    }

    public static void shutdown() {
        isDestroyed = true;
    }

    public void init() throws ServletException {
        isDestroyed = false;
    }

    public void destroy() {
        isDestroyed = true;
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final AtomicBoolean moreDataWillBeSent = new AtomicBoolean(true);
        Subscription sampleSubscription = null;
        int numberConnections = this.incrementAndGetCurrentConcurrentConnections();
        try {
            int maxNumberConnectionsAllowed = this.getMaxNumberConcurrentConnectionsAllowed();
            if (numberConnections > maxNumberConnectionsAllowed) {
                response.sendError(503, "MaxConcurrentConnections reached: " + maxNumberConnectionsAllowed);
            } else {
                int delay = this.getDelayFromHttpRequest(request);
                response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                final PrintWriter writer = response.getWriter();
                Observable<SampleData> sampledStream = this.getStream(delay);
                sampleSubscription = sampledStream.observeOn(Schedulers.io()).subscribe(new Subscriber<SampleData>(){

                    public void onCompleted() {
                        logger.error("HystrixSampleSseServlet: ({}) received unexpected OnCompleted from sample stream", (Object)((Object)((Object)this)).getClass().getSimpleName());
                        moreDataWillBeSent.set(false);
                    }

                    public void onError(Throwable e) {
                        moreDataWillBeSent.set(false);
                    }

                    public void onNext(SampleData sampleData) {
                        if (sampleData != null) {
                            String sampleDataAsStr = null;
                            try {
                                sampleDataAsStr = HystrixSampleSseServlet.this.convertToString(sampleData);
                            }
                            catch (IOException ioe) {
                                logger.error("Error converting configuration to JSON ", (Throwable)ioe);
                            }
                            if (sampleDataAsStr != null) {
                                try {
                                    writer.print("data: " + sampleDataAsStr + "\n\n");
                                    if (writer.checkError()) {
                                        throw new IOException("io error");
                                    }
                                    writer.flush();
                                }
                                catch (IOException ioe) {
                                    moreDataWillBeSent.set(false);
                                }
                            }
                        }
                    }
                });
                while (moreDataWillBeSent.get() && !isDestroyed) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        moreDataWillBeSent.set(false);
                    }
                }
            }
        }
        finally {
            this.decrementCurrentConcurrentConnections();
            if (sampleSubscription != null && !sampleSubscription.isUnsubscribed()) {
                sampleSubscription.unsubscribe();
            }
        }
    }
}

