/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.config.HystrixCollapserConfiguration;
import com.netflix.hystrix.config.HystrixCommandConfiguration;
import com.netflix.hystrix.config.HystrixConfiguration;
import com.netflix.hystrix.config.HystrixThreadPoolConfiguration;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialHystrixConfiguration
extends SerialHystrixMetric {
    private static final Logger logger = LoggerFactory.getLogger(SerialHystrixConfiguration.class);

    public static byte[] toBytes(HystrixConfiguration config) {
        byte[] retVal = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            CBORGenerator cbor = cborFactory.createGenerator((OutputStream)bos);
            SerialHystrixConfiguration.serializeConfiguration(config, (JsonGenerator)cbor);
            retVal = bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retVal;
    }

    public static String toJsonString(HystrixConfiguration config) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator((Writer)jsonString);
            SerialHystrixConfiguration.serializeConfiguration(config, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    private static void serializeConfiguration(HystrixConfiguration config, JsonGenerator json) {
        try {
            json.writeStartObject();
            json.writeStringField("type", "HystrixConfig");
            json.writeObjectFieldStart("commands");
            for (Map.Entry entry : config.getCommandConfig().entrySet()) {
                HystrixCommandKey key = (HystrixCommandKey)entry.getKey();
                HystrixCommandConfiguration commandConfig = (HystrixCommandConfiguration)entry.getValue();
                SerialHystrixConfiguration.writeCommandConfigJson(json, key, commandConfig);
            }
            json.writeEndObject();
            json.writeObjectFieldStart("threadpools");
            for (Map.Entry entry : config.getThreadPoolConfig().entrySet()) {
                HystrixThreadPoolKey threadPoolKey = (HystrixThreadPoolKey)entry.getKey();
                HystrixThreadPoolConfiguration threadPoolConfig = (HystrixThreadPoolConfiguration)entry.getValue();
                SerialHystrixConfiguration.writeThreadPoolConfigJson(json, threadPoolKey, threadPoolConfig);
            }
            json.writeEndObject();
            json.writeObjectFieldStart("collapsers");
            for (Map.Entry entry : config.getCollapserConfig().entrySet()) {
                HystrixCollapserKey collapserKey = (HystrixCollapserKey)entry.getKey();
                HystrixCollapserConfiguration collapserConfig = (HystrixCollapserConfiguration)entry.getValue();
                SerialHystrixConfiguration.writeCollapserConfigJson(json, collapserKey, collapserConfig);
            }
            json.writeEndObject();
            json.writeEndObject();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HystrixConfiguration fromByteBuffer(ByteBuffer bb) {
        byte[] byteArray = new byte[bb.remaining()];
        bb.get(byteArray);
        HashMap<HystrixCommandKey, HystrixCommandConfiguration> commandConfigMap = new HashMap<HystrixCommandKey, HystrixCommandConfiguration>();
        HashMap<HystrixThreadPoolKey, HystrixThreadPoolConfiguration> threadPoolConfigMap = new HashMap<HystrixThreadPoolKey, HystrixThreadPoolConfiguration>();
        HashMap<HystrixCollapserKey, HystrixCollapserConfiguration> collapserConfigMap = new HashMap<HystrixCollapserKey, HystrixCollapserConfiguration>();
        try {
            CBORParser parser = cborFactory.createParser(byteArray);
            JsonNode rootNode = (JsonNode)mapper.readTree((JsonParser)parser);
            Iterator commands = rootNode.path("commands").fields();
            Iterator threadPools = rootNode.path("threadpools").fields();
            Iterator collapsers = rootNode.path("collapsers").fields();
            while (commands.hasNext()) {
                Map.Entry command = (Map.Entry)commands.next();
                JsonNode executionConfig = ((JsonNode)command.getValue()).path("execution");
                JsonNode circuitBreakerConfig = ((JsonNode)command.getValue()).path("circuitBreaker");
                JsonNode metricsConfig = ((JsonNode)command.getValue()).path("metrics");
                HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)((String)command.getKey()));
                HystrixCommandConfiguration commandConfig = new HystrixCommandConfiguration(commandKey, HystrixThreadPoolKey.Factory.asKey((String)((JsonNode)command.getValue()).path("threadPoolKey").asText()), HystrixCommandGroupKey.Factory.asKey((String)((JsonNode)command.getValue()).path("groupKey").asText()), new HystrixCommandConfiguration.HystrixCommandExecutionConfig(executionConfig.path("semaphoreSize").asInt(), HystrixCommandProperties.ExecutionIsolationStrategy.valueOf((String)executionConfig.path("isolationStrategy").asText()), executionConfig.path("threadInterruptOnTimeout").asBoolean(), executionConfig.path("threadPoolKeyOverride").asText(), executionConfig.path("timeoutEnabled").asBoolean(), executionConfig.path("timeoutInMilliseconds").asInt(), executionConfig.path("fallbackEnabled").asBoolean(), executionConfig.path("fallbackSemaphoreSize").asInt(), executionConfig.path("requestCacheEnabled").asBoolean(), executionConfig.path("requestLogEnabled").asBoolean()), new HystrixCommandConfiguration.HystrixCommandCircuitBreakerConfig(circuitBreakerConfig.path("enabled").asBoolean(), circuitBreakerConfig.path("errorPercentageThreshold").asInt(), circuitBreakerConfig.path("isForcedClosed").asBoolean(), circuitBreakerConfig.path("isForcedOpen").asBoolean(), circuitBreakerConfig.path("requestVolumeThreshold").asInt(), circuitBreakerConfig.path("sleepInMilliseconds").asInt()), new HystrixCommandConfiguration.HystrixCommandMetricsConfig(metricsConfig.path("healthBucketSizeInMs").asInt(), metricsConfig.path("percentileEnabled").asBoolean(), metricsConfig.path("percentileBucketCount").asInt(), metricsConfig.path("percentileBucketSizeInMilliseconds").asInt(), metricsConfig.path("counterBucketCount").asInt(), metricsConfig.path("counterBucketSizeInMilliseconds").asInt()));
                commandConfigMap.put(commandKey, commandConfig);
            }
            while (threadPools.hasNext()) {
                Map.Entry threadPool = (Map.Entry)threadPools.next();
                HystrixThreadPoolKey threadPoolKey = HystrixThreadPoolKey.Factory.asKey((String)((String)threadPool.getKey()));
                HystrixThreadPoolConfiguration threadPoolConfig = new HystrixThreadPoolConfiguration(threadPoolKey, ((JsonNode)threadPool.getValue()).path("coreSize").asInt(), ((JsonNode)threadPool.getValue()).path("maxQueueSize").asInt(), ((JsonNode)threadPool.getValue()).path("queueRejectionThreshold").asInt(), ((JsonNode)threadPool.getValue()).path("keepAliveTimeInMinutes").asInt(), ((JsonNode)threadPool.getValue()).path("counterBucketCount").asInt(), ((JsonNode)threadPool.getValue()).path("counterBucketSizeInMilliseconds").asInt());
                threadPoolConfigMap.put(threadPoolKey, threadPoolConfig);
            }
            while (collapsers.hasNext()) {
                Map.Entry collapser = (Map.Entry)collapsers.next();
                HystrixCollapserKey collapserKey = HystrixCollapserKey.Factory.asKey((String)((String)collapser.getKey()));
                JsonNode metricsConfig = ((JsonNode)collapser.getValue()).path("metrics");
                HystrixCollapserConfiguration collapserConfig = new HystrixCollapserConfiguration(collapserKey, ((JsonNode)collapser.getValue()).path("maxRequestsInBatch").asInt(), ((JsonNode)collapser.getValue()).path("timerDelayInMilliseconds").asInt(), ((JsonNode)collapser.getValue()).path("requestCacheEnabled").asBoolean(), new HystrixCollapserConfiguration.CollapserMetricsConfig(metricsConfig.path("percentileBucketCount").asInt(), metricsConfig.path("percentileBucketSizeInMilliseconds").asInt(), metricsConfig.path("percentileEnabled").asBoolean(), metricsConfig.path("counterBucketCount").asInt(), metricsConfig.path("counterBucketSizeInMilliseconds").asInt()));
                collapserConfigMap.put(collapserKey, collapserConfig);
            }
        }
        catch (IOException ioe) {
            logger.error("IO Exception during deserialization of HystrixConfiguration : " + ioe);
        }
        return new HystrixConfiguration(commandConfigMap, threadPoolConfigMap, collapserConfigMap);
    }

    private static void writeCommandConfigJson(JsonGenerator json, HystrixCommandKey key, HystrixCommandConfiguration commandConfig) throws IOException {
        json.writeObjectFieldStart(key.name());
        json.writeStringField("threadPoolKey", commandConfig.getThreadPoolKey().name());
        json.writeStringField("groupKey", commandConfig.getGroupKey().name());
        json.writeObjectFieldStart("execution");
        HystrixCommandConfiguration.HystrixCommandExecutionConfig executionConfig = commandConfig.getExecutionConfig();
        json.writeStringField("isolationStrategy", executionConfig.getIsolationStrategy().name());
        json.writeStringField("threadPoolKeyOverride", executionConfig.getThreadPoolKeyOverride());
        json.writeBooleanField("requestCacheEnabled", executionConfig.isRequestCacheEnabled());
        json.writeBooleanField("requestLogEnabled", executionConfig.isRequestLogEnabled());
        json.writeBooleanField("timeoutEnabled", executionConfig.isTimeoutEnabled());
        json.writeBooleanField("fallbackEnabled", executionConfig.isFallbackEnabled());
        json.writeNumberField("timeoutInMilliseconds", executionConfig.getTimeoutInMilliseconds());
        json.writeNumberField("semaphoreSize", executionConfig.getSemaphoreMaxConcurrentRequests());
        json.writeNumberField("fallbackSemaphoreSize", executionConfig.getFallbackMaxConcurrentRequest());
        json.writeBooleanField("threadInterruptOnTimeout", executionConfig.isThreadInterruptOnTimeout());
        json.writeEndObject();
        json.writeObjectFieldStart("metrics");
        HystrixCommandConfiguration.HystrixCommandMetricsConfig metricsConfig = commandConfig.getMetricsConfig();
        json.writeNumberField("healthBucketSizeInMs", metricsConfig.getHealthIntervalInMilliseconds());
        json.writeNumberField("percentileBucketSizeInMilliseconds", metricsConfig.getRollingPercentileBucketSizeInMilliseconds());
        json.writeNumberField("percentileBucketCount", metricsConfig.getRollingCounterNumberOfBuckets());
        json.writeBooleanField("percentileEnabled", metricsConfig.isRollingPercentileEnabled());
        json.writeNumberField("counterBucketSizeInMilliseconds", metricsConfig.getRollingCounterBucketSizeInMilliseconds());
        json.writeNumberField("counterBucketCount", metricsConfig.getRollingCounterNumberOfBuckets());
        json.writeEndObject();
        json.writeObjectFieldStart("circuitBreaker");
        HystrixCommandConfiguration.HystrixCommandCircuitBreakerConfig circuitBreakerConfig = commandConfig.getCircuitBreakerConfig();
        json.writeBooleanField("enabled", circuitBreakerConfig.isEnabled());
        json.writeBooleanField("isForcedOpen", circuitBreakerConfig.isForceOpen());
        json.writeBooleanField("isForcedClosed", circuitBreakerConfig.isForceOpen());
        json.writeNumberField("requestVolumeThreshold", circuitBreakerConfig.getRequestVolumeThreshold());
        json.writeNumberField("errorPercentageThreshold", circuitBreakerConfig.getErrorThresholdPercentage());
        json.writeNumberField("sleepInMilliseconds", circuitBreakerConfig.getSleepWindowInMilliseconds());
        json.writeEndObject();
        json.writeEndObject();
    }

    private static void writeThreadPoolConfigJson(JsonGenerator json, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolConfiguration threadPoolConfig) throws IOException {
        json.writeObjectFieldStart(threadPoolKey.name());
        json.writeNumberField("coreSize", threadPoolConfig.getCoreSize());
        json.writeNumberField("maxQueueSize", threadPoolConfig.getMaxQueueSize());
        json.writeNumberField("queueRejectionThreshold", threadPoolConfig.getQueueRejectionThreshold());
        json.writeNumberField("keepAliveTimeInMinutes", threadPoolConfig.getKeepAliveTimeInMinutes());
        json.writeNumberField("counterBucketSizeInMilliseconds", threadPoolConfig.getRollingCounterBucketSizeInMilliseconds());
        json.writeNumberField("counterBucketCount", threadPoolConfig.getRollingCounterNumberOfBuckets());
        json.writeEndObject();
    }

    private static void writeCollapserConfigJson(JsonGenerator json, HystrixCollapserKey collapserKey, HystrixCollapserConfiguration collapserConfig) throws IOException {
        json.writeObjectFieldStart(collapserKey.name());
        json.writeNumberField("maxRequestsInBatch", collapserConfig.getMaxRequestsInBatch());
        json.writeNumberField("timerDelayInMilliseconds", collapserConfig.getTimerDelayInMilliseconds());
        json.writeBooleanField("requestCacheEnabled", collapserConfig.isRequestCacheEnabled());
        json.writeObjectFieldStart("metrics");
        HystrixCollapserConfiguration.CollapserMetricsConfig metricsConfig = collapserConfig.getCollapserMetricsConfig();
        json.writeNumberField("percentileBucketSizeInMilliseconds", metricsConfig.getRollingPercentileBucketSizeInMilliseconds());
        json.writeNumberField("percentileBucketCount", metricsConfig.getRollingCounterNumberOfBuckets());
        json.writeBooleanField("percentileEnabled", metricsConfig.isRollingPercentileEnabled());
        json.writeNumberField("counterBucketSizeInMilliseconds", metricsConfig.getRollingCounterBucketSizeInMilliseconds());
        json.writeNumberField("counterBucketCount", metricsConfig.getRollingCounterNumberOfBuckets());
        json.writeEndObject();
        json.writeEndObject();
    }
}

