/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixMetrics;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;

public class HystrixServoMetricsPublisherCommand
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherCommand {
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;

    public HystrixServoMetricsPublisherCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixCommand";
            }

            public String tagString() {
                return "HystrixCommand";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixCommand_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"isCircuitBreakerOpen").build()){

            @Override
            public Boolean getValue() {
                return HystrixServoMetricsPublisherCommand.this.circuitBreaker.isOpen();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"currentTime").withTag((Tag)DataSourceLevel.DEBUG).build()){

            @Override
            public Number getValue() {
                return System.currentTimeMillis();
            }
        });
        monitors.add(this.getCumulativeCountForEvent("countBadRequests", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.BAD_REQUEST));
        monitors.add(this.getCumulativeCountForEvent("countCollapsedRequests", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.COLLAPSED));
        monitors.add(this.getCumulativeCountForEvent("countExceptionsThrown", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.EXCEPTION_THROWN));
        monitors.add(this.getCumulativeCountForEvent("countFailure", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FAILURE));
        monitors.add(this.getCumulativeCountForEvent("countFallbackFailure", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_FAILURE));
        monitors.add(this.getCumulativeCountForEvent("countFallbackRejection", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_REJECTION));
        monitors.add(this.getCumulativeCountForEvent("countFallbackSuccess", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_SUCCESS));
        monitors.add(this.getCumulativeCountForEvent("countResponsesFromCache", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
        monitors.add(this.getCumulativeCountForEvent("countSemaphoreRejected", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
        monitors.add(this.getCumulativeCountForEvent("countShortCircuited", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SHORT_CIRCUITED));
        monitors.add(this.getCumulativeCountForEvent("countSuccess", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SUCCESS));
        monitors.add(this.getCumulativeCountForEvent("countThreadPoolRejected", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
        monitors.add(this.getCumulativeCountForEvent("countTimeout", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.TIMEOUT));
        monitors.add(this.getRollingCountForEvent("rollingCountBadRequests", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.BAD_REQUEST));
        monitors.add(this.getRollingCountForEvent("rollingCountCollapsedRequests", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.COLLAPSED));
        monitors.add(this.getRollingCountForEvent("rollingCountExceptionsThrown", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.EXCEPTION_THROWN));
        monitors.add(this.getRollingCountForEvent("rollingCountFailure", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FAILURE));
        monitors.add(this.getRollingCountForEvent("rollingCountFallbackFailure", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_FAILURE));
        monitors.add(this.getRollingCountForEvent("rollingCountFallbackRejection", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_REJECTION));
        monitors.add(this.getRollingCountForEvent("rollingCountFallbackSuccess", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.FALLBACK_SUCCESS));
        monitors.add(this.getRollingCountForEvent("rollingCountResponsesFromCache", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
        monitors.add(this.getRollingCountForEvent("rollingCountSemaphoreRejected", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
        monitors.add(this.getRollingCountForEvent("rollingCountShortCircuited", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SHORT_CIRCUITED));
        monitors.add(this.getRollingCountForEvent("rollingCountSuccess", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.SUCCESS));
        monitors.add(this.getRollingCountForEvent("rollingCountThreadPoolRejected", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
        monitors.add(this.getRollingCountForEvent("rollingCountTimeout", (HystrixMetrics)this.metrics, HystrixRollingNumberEvent.TIMEOUT));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"executionSemaphorePermitsInUse").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"errorPercentage").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_mean").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_5").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(5.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_25").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(25.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_50").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(50.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_75").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(75.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_90").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(90.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_99").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyExecute_percentile_995").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(99.5);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_mean").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_5").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(5.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_25").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(25.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_50").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(50.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_75").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(75.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_90").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(90.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_99").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.0);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"latencyTotal_percentile_995").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(99.5);
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"commandGroup").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.commandGroupKey != null ? HystrixServoMetricsPublisherCommand.this.commandGroupKey.name() : null;
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_rollingStatisticalWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerRequestVolumeThreshold").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerSleepWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerErrorThresholdPercentage").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceOpen").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceClosed").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationThreadTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"propertyValue_executionIsolationStrategy").build()){

            @Override
            public String getValue() {
                return ((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationStrategy().get()).name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_metricsRollingPercentileEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingPercentileEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestCacheEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestCacheEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestLogEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestLogEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        return monitors;
    }
}

