/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;
import rx.functions.Func0;

public class HystrixServoMetricsPublisherCommand
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherCommand {
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;
    protected final Func0<Number> currentConcurrentExecutionCountThunk = new Func0<Number>(){

        public Integer call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
        }
    };
    protected final Func0<Number> rollingMaxConcurrentExecutionCountThunk = new Func0<Number>(){

        public Long call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getRollingMaxConcurrentExecutions();
        }
    };
    protected final Func0<Number> errorPercentageThunk = new Func0<Number>(){

        public Integer call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
        }
    };
    protected final Func0<Number> currentTimeThunk = new Func0<Number>(){

        public Number call() {
            return System.currentTimeMillis();
        }
    };

    public HystrixServoMetricsPublisherCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixCommand";
            }

            public String tagString() {
                return "HystrixCommand";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixCommand_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    @Deprecated
    protected final HystrixRollingNumberEvent getRollingNumberTypeFromEventType(HystrixEventType eventType) {
        return HystrixRollingNumberEvent.from((HystrixEventType)eventType);
    }

    protected Monitor<?> getCumulativeMonitor(String name, final HystrixEventType event) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getCumulativeCount(HystrixRollingNumberEvent.from((HystrixEventType)event));
            }
        };
    }

    protected Monitor<?> getRollingMonitor(String name, final HystrixEventType event) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getRollingCount(HystrixRollingNumberEvent.from((HystrixEventType)event));
            }
        };
    }

    protected Monitor<?> getExecutionLatencyMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        };
    }

    protected Monitor<?> getExecutionLatencyPercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(percentile);
            }
        };
    }

    protected Monitor<?> getTotalLatencyMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        };
    }

    protected Monitor<?> getTotalLatencyPercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(percentile);
            }
        };
    }

    protected Monitor<?> getCurrentValueMonitor(String name, final Func0<Number> metricToEvaluate) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return (Number)metricToEvaluate.call();
            }
        };
    }

    protected Monitor<?> getCurrentValueMonitor(String name, final Func0<Number> metricToEvaluate, Tag tag) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag(tag).build()){

            @Override
            public Number getValue() {
                return (Number)metricToEvaluate.call();
            }
        };
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"isCircuitBreakerOpen").build()){

            @Override
            public Boolean getValue() {
                return HystrixServoMetricsPublisherCommand.this.circuitBreaker.isOpen();
            }
        });
        monitors.add(this.getCurrentValueMonitor("currentTime", this.currentTimeThunk, (Tag)DataSourceLevel.DEBUG));
        monitors.add(this.getCumulativeMonitor("countBadRequests", HystrixEventType.BAD_REQUEST));
        monitors.add(this.getCumulativeMonitor("countCollapsedRequests", HystrixEventType.COLLAPSED));
        monitors.add(this.getCumulativeMonitor("countEmit", HystrixEventType.EMIT));
        monitors.add(this.getCumulativeMonitor("countExceptionsThrown", HystrixEventType.EXCEPTION_THROWN));
        monitors.add(this.getCumulativeMonitor("countFailure", HystrixEventType.FAILURE));
        monitors.add(this.getCumulativeMonitor("countFallbackEmit", HystrixEventType.FALLBACK_EMIT));
        monitors.add(this.getCumulativeMonitor("countFallbackFailure", HystrixEventType.FALLBACK_FAILURE));
        monitors.add(this.getCumulativeMonitor("countFallbackMissing", HystrixEventType.FALLBACK_MISSING));
        monitors.add(this.getCumulativeMonitor("countFallbackRejection", HystrixEventType.FALLBACK_REJECTION));
        monitors.add(this.getCumulativeMonitor("countFallbackSuccess", HystrixEventType.FALLBACK_SUCCESS));
        monitors.add(this.getCumulativeMonitor("countResponsesFromCache", HystrixEventType.RESPONSE_FROM_CACHE));
        monitors.add(this.getCumulativeMonitor("countSemaphoreRejected", HystrixEventType.SEMAPHORE_REJECTED));
        monitors.add(this.getCumulativeMonitor("countShortCircuited", HystrixEventType.SHORT_CIRCUITED));
        monitors.add(this.getCumulativeMonitor("countSuccess", HystrixEventType.SUCCESS));
        monitors.add(this.getCumulativeMonitor("countThreadPoolRejected", HystrixEventType.THREAD_POOL_REJECTED));
        monitors.add(this.getCumulativeMonitor("countTimeout", HystrixEventType.TIMEOUT));
        monitors.add(this.getRollingMonitor("rollingCountBadRequests", HystrixEventType.BAD_REQUEST));
        monitors.add(this.getRollingMonitor("rollingCountCollapsedRequests", HystrixEventType.COLLAPSED));
        monitors.add(this.getRollingMonitor("rollingCountEmit", HystrixEventType.EMIT));
        monitors.add(this.getRollingMonitor("rollingCountExceptionsThrown", HystrixEventType.EXCEPTION_THROWN));
        monitors.add(this.getRollingMonitor("rollingCountFailure", HystrixEventType.FAILURE));
        monitors.add(this.getRollingMonitor("rollingCountFallbackEmit", HystrixEventType.FALLBACK_EMIT));
        monitors.add(this.getRollingMonitor("rollingCountFallbackFailure", HystrixEventType.FALLBACK_FAILURE));
        monitors.add(this.getRollingMonitor("rollingCountFallbackMissing", HystrixEventType.FALLBACK_MISSING));
        monitors.add(this.getRollingMonitor("rollingCountFallbackRejection", HystrixEventType.FALLBACK_REJECTION));
        monitors.add(this.getRollingMonitor("rollingCountFallbackSuccess", HystrixEventType.FALLBACK_SUCCESS));
        monitors.add(this.getRollingMonitor("rollingCountResponsesFromCache", HystrixEventType.RESPONSE_FROM_CACHE));
        monitors.add(this.getRollingMonitor("rollingCountSemaphoreRejected", HystrixEventType.SEMAPHORE_REJECTED));
        monitors.add(this.getRollingMonitor("rollingCountShortCircuited", HystrixEventType.SHORT_CIRCUITED));
        monitors.add(this.getRollingMonitor("rollingCountSuccess", HystrixEventType.SUCCESS));
        monitors.add(this.getRollingMonitor("rollingCountThreadPoolRejected", HystrixEventType.THREAD_POOL_REJECTED));
        monitors.add(this.getRollingMonitor("rollingCountTimeout", HystrixEventType.TIMEOUT));
        monitors.add(this.getCurrentValueMonitor("executionSemaphorePermitsInUse", this.currentConcurrentExecutionCountThunk));
        monitors.add(this.getCurrentValueMonitor("errorPercentage", this.errorPercentageThunk));
        monitors.add(this.getExecutionLatencyMeanMonitor("latencyExecute_mean"));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_5", 5.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_25", 25.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_50", 50.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_75", 75.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_90", 90.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_99", 99.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_995", 99.5));
        monitors.add(this.getTotalLatencyMeanMonitor("latencyTotal_mean"));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_5", 5.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_25", 25.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_50", 50.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_75", 75.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_90", 90.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_99", 99.0));
        monitors.add(this.getTotalLatencyPercentileMonitor("latencyTotal_percentile_995", 995.0));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"commandGroup").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.commandGroupKey != null ? HystrixServoMetricsPublisherCommand.this.commandGroupKey.name() : null;
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_rollingStatisticalWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerRequestVolumeThreshold").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerSleepWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerErrorThresholdPercentage").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceOpen").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceClosed").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationThreadTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"propertyValue_executionIsolationStrategy").build()){

            @Override
            public String getValue() {
                return ((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationStrategy().get()).name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_metricsRollingPercentileEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingPercentileEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestCacheEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestCacheEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestLogEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestLogEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        return monitors;
    }
}

