/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.metric.consumer.CumulativeThreadPoolEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolConcurrencyStream;
import com.netflix.hystrix.metric.consumer.RollingThreadPoolEventCounterStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;

public class HystrixServoMetricsPublisherThreadPool
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherThreadPool {
    private final HystrixThreadPoolKey key;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;

    public HystrixServoMetricsPublisherThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherThreadPool.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixThreadPool";
            }

            public String tagString() {
                return "HystrixThreadPool";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixThreadPool_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
        RollingThreadPoolEventCounterStream.getInstance((HystrixThreadPoolKey)this.key, (HystrixThreadPoolProperties)this.properties).startCachingStreamValuesIfUnstarted();
        CumulativeThreadPoolEventCounterStream.getInstance((HystrixThreadPoolKey)this.key, (HystrixThreadPoolProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingThreadPoolConcurrencyStream.getInstance((HystrixThreadPoolKey)this.key, (HystrixThreadPoolProperties)this.properties).startCachingStreamValuesIfUnstarted();
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    protected Monitor<Number> getCumulativeMonitor(String name, final HystrixEventType.ThreadPool event) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCumulativeCount(event);
            }
        };
    }

    protected Monitor<Number> getRollingMonitor(String name, final HystrixEventType.ThreadPool event) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getRollingCount(event);
            }
        };
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"name").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.key.name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"currentTime").withTag((Tag)DataSourceLevel.DEBUG).build()){

            @Override
            public Number getValue() {
                return System.currentTimeMillis();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"threadActiveCount").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCurrentActiveCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"completedTaskCount").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCurrentCompletedTaskCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"largestPoolSize").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCurrentLargestPoolSize();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"totalTaskCount").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCurrentTaskCount();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"queueSize").build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getCurrentQueueSize();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"rollingMaxActiveThreads").withTag((Tag)DataSourceLevel.DEBUG).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherThreadPool.this.metrics.getRollingMaxActiveThreads();
            }
        });
        monitors.add(this.getCumulativeMonitor("countThreadsExecuted", HystrixEventType.ThreadPool.EXECUTED));
        monitors.add(this.getCumulativeMonitor("countThreadsRejected", HystrixEventType.ThreadPool.REJECTED));
        monitors.add(this.getRollingMonitor("rollingCountThreadsExecuted", HystrixEventType.ThreadPool.EXECUTED));
        monitors.add(this.getRollingMonitor("rollingCountCommandsRejected", HystrixEventType.ThreadPool.REJECTED));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_corePoolSize").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherThreadPool.this.properties.coreSize().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_keepAliveTimeInMinutes").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherThreadPool.this.properties.keepAliveTimeMinutes().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_queueSizeRejectionThreshold").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherThreadPool.this.properties.queueSizeRejectionThreshold().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_maxQueueSize").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherThreadPool.this.properties.maxQueueSize().get();
            }
        });
        return monitors;
    }
}

