/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.metric.consumer.CumulativeCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCommandLatencyDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCommandMaxConcurrencyStream;
import com.netflix.hystrix.metric.consumer.RollingCommandUserLatencyDistributionStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class HystrixServoMetricsPublisherCommand
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherCommand {
    private static final Logger logger = LoggerFactory.getLogger(HystrixServoMetricsPublisherCommand.class);
    private final HystrixCommandKey key;
    private final HystrixCommandGroupKey commandGroupKey;
    private final HystrixCommandMetrics metrics;
    private final HystrixCircuitBreaker circuitBreaker;
    private final HystrixCommandProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;
    protected final Func0<Number> currentConcurrentExecutionCountThunk = new Func0<Number>(){

        public Integer call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getCurrentConcurrentExecutionCount();
        }
    };
    protected final Func0<Number> rollingMaxConcurrentExecutionCountThunk = new Func0<Number>(){

        public Long call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getRollingMaxConcurrentExecutions();
        }
    };
    protected final Func0<Number> errorPercentageThunk = new Func0<Number>(){

        public Integer call() {
            return HystrixServoMetricsPublisherCommand.this.metrics.getHealthCounts().getErrorPercentage();
        }
    };
    protected final Func0<Number> currentTimeThunk = new Func0<Number>(){

        public Number call() {
            return System.currentTimeMillis();
        }
    };

    public HystrixServoMetricsPublisherCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandGroupKey, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        this.key = commandKey;
        this.commandGroupKey = commandGroupKey;
        this.metrics = metrics;
        this.circuitBreaker = circuitBreaker;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherCommand.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixCommand";
            }

            public String tagString() {
                return "HystrixCommand";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixCommand_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
        RollingCommandEventCounterStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        CumulativeCommandEventCounterStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandLatencyDistributionStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandUserLatencyDistributionStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCommandMaxConcurrencyStream.getInstance((HystrixCommandKey)this.key, (HystrixCommandProperties)this.properties).startCachingStreamValuesIfUnstarted();
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    @Deprecated
    protected final HystrixRollingNumberEvent getRollingNumberTypeFromEventType(HystrixEventType eventType) {
        return HystrixRollingNumberEvent.from((HystrixEventType)eventType);
    }

    protected Monitor<Number> getCumulativeMonitor(String name, final HystrixEventType event) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getCumulativeCount(event);
            }
        };
    }

    protected Monitor<Number> safelyGetCumulativeMonitor(final String name, final Func0<HystrixEventType> eventThunk) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                try {
                    HystrixEventType eventType = (HystrixEventType)eventThunk.call();
                    return HystrixServoMetricsPublisherCommand.this.metrics.getCumulativeCount(HystrixRollingNumberEvent.from((HystrixEventType)eventType));
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing Servo metrics, error looking up eventType for : " + name + ".  Please check that all Hystrix versions are the same!");
                    return 0L;
                }
            }
        };
    }

    protected Monitor<Number> getRollingMonitor(String name, final HystrixEventType event) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getRollingCount(event);
            }
        };
    }

    protected Monitor<Number> safelyGetRollingMonitor(final String name, final Func0<HystrixEventType> eventThunk) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                try {
                    HystrixEventType eventType = (HystrixEventType)eventThunk.call();
                    return HystrixServoMetricsPublisherCommand.this.metrics.getRollingCount(HystrixRollingNumberEvent.from((HystrixEventType)eventType));
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing Servo metrics, error looking up eventType for : " + name + ".  Please check that all Hystrix versions are the same!");
                    return 0L;
                }
            }
        };
    }

    protected Monitor<Number> getExecutionLatencyMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimeMean();
            }
        };
    }

    protected Monitor<Number> getExecutionLatencyPercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getExecutionTimePercentile(percentile);
            }
        };
    }

    protected Monitor<Number> getTotalLatencyMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimeMean();
            }
        };
    }

    protected Monitor<Number> getTotalLatencyPercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCommand.this.metrics.getTotalTimePercentile(percentile);
            }
        };
    }

    protected Monitor<Number> getCurrentValueMonitor(String name, final Func0<Number> metricToEvaluate) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return (Number)metricToEvaluate.call();
            }
        };
    }

    protected Monitor<Number> getCurrentValueMonitor(String name, final Func0<Number> metricToEvaluate, Tag tag) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag(tag).build()){

            @Override
            public Number getValue() {
                return (Number)metricToEvaluate.call();
            }
        };
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"isCircuitBreakerOpen").build()){

            @Override
            public Boolean getValue() {
                return HystrixServoMetricsPublisherCommand.this.circuitBreaker.isOpen();
            }
        });
        monitors.add(this.getCurrentValueMonitor("currentTime", this.currentTimeThunk, (Tag)DataSourceLevel.DEBUG));
        monitors.add(this.safelyGetCumulativeMonitor("countBadRequests", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.BAD_REQUEST;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countCollapsedRequests", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.COLLAPSED;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countEmit", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.EMIT;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countExceptionsThrown", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.EXCEPTION_THROWN;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFailure", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FAILURE;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFallbackEmit", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_EMIT;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFallbackFailure", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_FAILURE;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFallbackMissing", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_MISSING;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFallbackRejection", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_REJECTION;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countFallbackSuccess", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_SUCCESS;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countResponsesFromCache", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.RESPONSE_FROM_CACHE;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countSemaphoreRejected", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SEMAPHORE_REJECTED;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countShortCircuited", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SHORT_CIRCUITED;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countSuccess", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SUCCESS;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countThreadPoolRejected", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.THREAD_POOL_REJECTED;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countTimeout", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.TIMEOUT;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountBadRequests", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.BAD_REQUEST;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountCollapsedRequests", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.COLLAPSED;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountEmit", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.EMIT;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountExceptionsThrown", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.EXCEPTION_THROWN;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFailure", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FAILURE;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFallbackEmit", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_EMIT;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFallbackFailure", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_FAILURE;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFallbackMissing", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_MISSING;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFallbackRejection", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_REJECTION;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountFallbackSuccess", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.FALLBACK_SUCCESS;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountResponsesFromCache", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.RESPONSE_FROM_CACHE;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountSemaphoreRejected", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SEMAPHORE_REJECTED;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountShortCircuited", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SHORT_CIRCUITED;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountSuccess", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.SUCCESS;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountThreadPoolRejected", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.THREAD_POOL_REJECTED;
            }
        }));
        monitors.add(this.safelyGetRollingMonitor("rollingCountTimeout", new Func0<HystrixEventType>(){

            public HystrixEventType call() {
                return HystrixEventType.TIMEOUT;
            }
        }));
        monitors.add(this.getCurrentValueMonitor("executionSemaphorePermitsInUse", this.currentConcurrentExecutionCountThunk));
        monitors.add(this.getCurrentValueMonitor("errorPercentage", this.errorPercentageThunk));
        monitors.add(this.getExecutionLatencyMeanMonitor("latencyExecute_mean"));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_5", 5.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_25", 25.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_50", 50.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_75", 75.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_90", 90.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_99", 99.0));
        monitors.add(this.getExecutionLatencyPercentileMonitor("latencyExecute_percentile_995", 99.5));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"commandGroup").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherCommand.this.commandGroupKey != null ? HystrixServoMetricsPublisherCommand.this.commandGroupKey.name() : null;
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_rollingStatisticalWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerRequestVolumeThreshold").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerRequestVolumeThreshold().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerSleepWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerSleepWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_circuitBreakerErrorThresholdPercentage").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerErrorThresholdPercentage().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceOpen").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceOpen().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_circuitBreakerForceClosed").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.circuitBreakerForceClosed().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationThreadTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionTimeoutInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionTimeoutInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"propertyValue_executionIsolationStrategy").build()){

            @Override
            public String getValue() {
                return ((HystrixCommandProperties.ExecutionIsolationStrategy)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationStrategy().get()).name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_metricsRollingPercentileEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.metricsRollingPercentileEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestCacheEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestCacheEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestLogEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCommand.this.properties.requestLogEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_executionIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.executionIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCommand.this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests().get();
            }
        });
        return monitors;
    }
}

