/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.servopublisher;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.contrib.servopublisher.HystrixServoMetricsPublisherAbstract;
import com.netflix.hystrix.metric.consumer.CumulativeCollapserEventCounterStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserBatchSizeDistributionStream;
import com.netflix.hystrix.metric.consumer.RollingCollapserEventCounterStream;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCollapser;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceLevel;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.tag.Tag;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func0;

public class HystrixServoMetricsPublisherCollapser
extends HystrixServoMetricsPublisherAbstract
implements HystrixMetricsPublisherCollapser {
    private static final Logger logger = LoggerFactory.getLogger(HystrixServoMetricsPublisherCollapser.class);
    private final HystrixCollapserKey key;
    private final HystrixCollapserMetrics metrics;
    private final HystrixCollapserProperties properties;
    private final Tag servoInstanceTag;
    private final Tag servoTypeTag;

    public HystrixServoMetricsPublisherCollapser(HystrixCollapserKey threadPoolKey, HystrixCollapserMetrics metrics, HystrixCollapserProperties properties) {
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.servoInstanceTag = new Tag(){

            public String getKey() {
                return "instance";
            }

            public String getValue() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }

            public String tagString() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }
        };
        this.servoTypeTag = new Tag(){

            public String getKey() {
                return "type";
            }

            public String getValue() {
                return "HystrixCollapser";
            }

            public String tagString() {
                return "HystrixCollapser";
            }
        };
    }

    public void initialize() {
        List<Monitor<?>> monitors = this.getServoMonitors();
        MonitorConfig commandMetricsConfig = MonitorConfig.builder((String)("HystrixCollapser_" + this.key.name())).build();
        BasicCompositeMonitor commandMetricsMonitor = new BasicCompositeMonitor(commandMetricsConfig, monitors);
        DefaultMonitorRegistry.getInstance().register((Monitor)commandMetricsMonitor);
        RollingCollapserBatchSizeDistributionStream.getInstance((HystrixCollapserKey)this.key, (HystrixCollapserProperties)this.properties).startCachingStreamValuesIfUnstarted();
        RollingCollapserEventCounterStream.getInstance((HystrixCollapserKey)this.key, (HystrixCollapserProperties)this.properties).startCachingStreamValuesIfUnstarted();
        CumulativeCollapserEventCounterStream.getInstance((HystrixCollapserKey)this.key, (HystrixCollapserProperties)this.properties).startCachingStreamValuesIfUnstarted();
    }

    @Override
    protected Tag getServoTypeTag() {
        return this.servoTypeTag;
    }

    @Override
    protected Tag getServoInstanceTag() {
        return this.servoInstanceTag;
    }

    protected Monitor<Number> getCumulativeMonitor(String name, final HystrixEventType.Collapser event) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getCumulativeCount(event);
            }
        };
    }

    protected Monitor<Number> safelyGetCumulativeMonitor(final String name, final Func0<HystrixEventType.Collapser> eventThunk) {
        return new HystrixServoMetricsPublisherAbstract.CounterMetric(MonitorConfig.builder((String)name).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                try {
                    return HystrixServoMetricsPublisherCollapser.this.metrics.getCumulativeCount((HystrixEventType.Collapser)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing Servo metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        };
    }

    protected Monitor<Number> getRollingMonitor(String name, final HystrixEventType.Collapser event) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getRollingCount(event);
            }
        };
    }

    protected Monitor<Number> safelyGetRollingMonitor(final String name, final Func0<HystrixEventType.Collapser> eventThunk) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).withTag((Tag)DataSourceLevel.DEBUG).withTag(this.getServoTypeTag()).withTag(this.getServoInstanceTag()).build()){

            @Override
            public Long getValue() {
                try {
                    return HystrixServoMetricsPublisherCollapser.this.metrics.getRollingCount((HystrixEventType.Collapser)eventThunk.call());
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing Servo metrics, error looking up eventType for : {}.  Please check that all Hystrix versions are the same!", (Object)name);
                    return 0L;
                }
            }
        };
    }

    protected Monitor<Number> getBatchSizeMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizeMean();
            }
        };
    }

    protected Monitor<Number> getBatchSizePercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getBatchSizePercentile(percentile);
            }
        };
    }

    protected Monitor<Number> getShardSizeMeanMonitor(String name) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizeMean();
            }
        };
    }

    protected Monitor<Number> getShardSizePercentileMonitor(String name, final double percentile) {
        return new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)name).build()){

            @Override
            public Number getValue() {
                return HystrixServoMetricsPublisherCollapser.this.metrics.getShardSizePercentile(percentile);
            }
        };
    }

    private List<Monitor<?>> getServoMonitors() {
        ArrayList monitors = new ArrayList();
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<String>(MonitorConfig.builder((String)"name").build()){

            @Override
            public String getValue() {
                return HystrixServoMetricsPublisherCollapser.this.key.name();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.GaugeMetric(MonitorConfig.builder((String)"currentTime").withTag((Tag)DataSourceLevel.DEBUG).build()){

            @Override
            public Number getValue() {
                return System.currentTimeMillis();
            }
        });
        monitors.add(this.safelyGetCumulativeMonitor("countRequestsBatched", new Func0<HystrixEventType.Collapser>(){

            public HystrixEventType.Collapser call() {
                return HystrixEventType.Collapser.ADDED_TO_BATCH;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countBatches", new Func0<HystrixEventType.Collapser>(){

            public HystrixEventType.Collapser call() {
                return HystrixEventType.Collapser.BATCH_EXECUTED;
            }
        }));
        monitors.add(this.safelyGetCumulativeMonitor("countResponsesFromCache", new Func0<HystrixEventType.Collapser>(){

            public HystrixEventType.Collapser call() {
                return HystrixEventType.Collapser.RESPONSE_FROM_CACHE;
            }
        }));
        monitors.add(this.getBatchSizeMeanMonitor("batchSize_mean"));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_25", 25.0));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_50", 50.0));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_75", 75.0));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_95", 95.0));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_99", 99.0));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_99_5", 99.5));
        monitors.add(this.getBatchSizePercentileMonitor("batchSize_percentile_100", 100.0));
        monitors.add(this.getShardSizeMeanMonitor("shardSize_mean"));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_25", 25.0));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_50", 50.0));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_75", 75.0));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_95", 95.0));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_99", 99.0));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_99_5", 99.5));
        monitors.add(this.getShardSizePercentileMonitor("shardSize_percentile_100", 100.0));
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_rollingStatisticalWindowInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.metricsRollingStatisticalWindowInMilliseconds().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Boolean>(MonitorConfig.builder((String)"propertyValue_requestCacheEnabled").build()){

            @Override
            public Boolean getValue() {
                return (Boolean)HystrixServoMetricsPublisherCollapser.this.properties.requestCacheEnabled().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_maxRequestsInBatch").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.maxRequestsInBatch().get();
            }
        });
        monitors.add((Monitor<?>)new HystrixServoMetricsPublisherAbstract.InformationalMetric<Number>(MonitorConfig.builder((String)"propertyValue_timerDelayInMilliseconds").build()){

            @Override
            public Number getValue() {
                return (Number)HystrixServoMetricsPublisherCollapser.this.properties.timerDelayInMilliseconds().get();
            }
        });
        return monitors;
    }
}

