/*
 * Decompiled with CFR 0.152.
 */
package iep.com.netflix.iep.http;

import iep.com.netflix.iep.http.ClientConfig;
import iep.com.netflix.iep.http.Server;
import iep.com.netflix.iep.http.ServerRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicServerRegistry
implements ServerRegistry {
    private final Map<String, List<Server>> serversByVip;
    private final Set<Server> allServers;

    public BasicServerRegistry() {
        this(Collections.emptyMap());
    }

    public BasicServerRegistry(Map<String, List<Server>> map) {
        this.serversByVip = map;
        this.allServers = new HashSet<Server>();
        map.values().forEach(this.allServers::addAll);
    }

    @Override
    public boolean isStillAvailable(Server server) {
        return this.allServers.contains(server);
    }

    @Override
    public List<Server> getServers(String string, ClientConfig clientConfig) {
        List<Server> list = this.serversByVip.get(string);
        return list != null ? list : Collections.emptyList();
    }
}

