/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.pages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.view.Viewable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import netflix.admin.AdminConfigImpl;
import netflix.admin.AdminContainerConfig;
import netflix.adminresources.AdminPageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"text/html"})
@Singleton
public class AdminPageResource {
    private static final Logger LOG = LoggerFactory.getLogger(AdminPageResource.class);
    @Inject(optional=true)
    private AdminContainerConfig adminContainerConfig;
    @Inject(optional=true)
    private AdminPageRegistry adminPageRegistry;

    @PostConstruct
    public void init() {
        if (this.adminPageRegistry == null) {
            this.adminPageRegistry = new AdminPageRegistry();
        }
        if (this.adminContainerConfig == null) {
            this.adminContainerConfig = new AdminConfigImpl();
        }
    }

    @GET
    public Viewable showIndex() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("ajax_base", this.adminContainerConfig.ajaxDataResourceContext());
        model.put("template_base", this.adminContainerConfig.templateResourceContext());
        if (this.adminPageRegistry != null) {
            Collection adminPages = this.adminPageRegistry.getAllPages();
            model.put("adminPages", adminPages);
        }
        return new Viewable("/webadmin/home.ftl", model);
    }

    @GET
    @Path(value="/{view}")
    public Viewable showViewIndex(@PathParam(value="view") String view, @QueryParam(value="id") @DefaultValue(value="") String id) {
        LOG.info(view);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        model.put("ajax_base", this.adminContainerConfig.ajaxDataResourceContext());
        model.put("template_base", this.adminContainerConfig.templateResourceContext());
        if (this.adminPageRegistry != null && this.adminPageRegistry.getPageInfo(view) != null) {
            Map pageDataModel = this.adminPageRegistry.getPageInfo(view).getDataModel();
            if (pageDataModel != null) {
                model.putAll(pageDataModel);
            }
            return new Viewable(this.adminPageRegistry.getPageInfo(view).getPageTemplate(), model);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @POST
    @Path(value="/{view}")
    public Viewable createObject(@PathParam(value="view") String view, @QueryParam(value="id") @DefaultValue(value="") String id) {
        LOG.info(view);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        return new Viewable("/webadmin/" + view + "/create.ftl", model);
    }

    @GET
    @Path(value="/jmx/mbean")
    public Viewable showJMXMbean(@QueryParam(value="id") String id, @QueryParam(value="key") String key) {
        LOG.info("");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("id", id);
        model.put("key", key);
        model.put("ajax_base", this.adminContainerConfig.ajaxDataResourceContext());
        return new Viewable("/webadmin/jmx/view.ftl", model);
    }
}

