/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources;

import com.netflix.config.ConfigurationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netflix.adminresources.resources.MaskedResourceHelper;
import netflix.adminresources.resources.model.Property;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesHelper.class);

    public static List<Property> getAllProperties() {
        AbstractConfiguration configInstance = ConfigurationManager.getConfigInstance();
        ArrayList<Property> properties = new ArrayList<Property>();
        Iterator keys = null;
        try {
            keys = configInstance.getKeys();
        }
        catch (Exception e) {
            LOG.error("Exception fetching all property keys ", (Throwable)e);
        }
        Set<String> maskedResources = MaskedResourceHelper.getMaskedPropertiesSet();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = null;
                value = maskedResources.contains(key) ? "**** MASKED ****" : configInstance.getProperty(key);
                Property property = new Property(key, value.toString(), null);
                properties.add(property);
            }
            catch (Exception e) {
                LOG.info("Exception fetching property value for key " + key, (Throwable)e);
            }
        }
        return properties;
    }

    public static Map<String, String> buildPropertiesMap(List<Property> properties) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (Property prop : properties) {
            propsMap.put(prop.getName(), prop.getValue());
        }
        return propsMap;
    }
}

