/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources.jmx;

import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DynaTreeNode {
    private String title;
    private String key;
    private String mode;
    private Map<String, DynaTreeNode> children;
    private boolean noLink = true;

    public DynaTreeNode setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public DynaTreeNode setNoLink(boolean noLink) {
        this.noLink = noLink;
        return this;
    }

    public boolean getNoLink() {
        return this.noLink;
    }

    public DynaTreeNode setKey(String key) {
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public DynaTreeNode setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public String getMode() {
        return this.mode;
    }

    public Map<String, DynaTreeNode> getChildren() {
        if (this.children == null) {
            this.children = new TreeMap<String, DynaTreeNode>();
        }
        return this.children;
    }

    public DynaTreeNode getChild(String title) {
        return this.getChildren().get(title);
    }

    public void putChild(DynaTreeNode child) {
        this.getChildren().put(child.title, child);
    }

    public JSONObject toJSONObject() throws JSONException {
        return new JSONObject().put("title", (Object)this.title).put("key", (Object)this.key).put("noLink", this.noLink).put("mode", (Object)this.mode).put("expand", true).put("children", (Object)this.getChildrenJSONArray());
    }

    public JSONArray getChildrenJSONArray() {
        JSONArray ar = null;
        if (this.children != null) {
            ar = new JSONArray();
            for (DynaTreeNode a : this.children.values()) {
                try {
                    ar.put((Object)a.toJSONObject());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return ar;
    }
}

