/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import netflix.adminresources.resources.PropertiesHelper;
import netflix.adminresources.resources.model.Property;

@Path(value="/allprops")
@Produces(value={"application/json"})
public class AllPropsResource {
    @GET
    public Response getAllProperties() {
        List<Property> allProperties = PropertiesHelper.getAllProperties();
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new PropsResponse(PropertiesHelper.buildPropertiesMap(allProperties)));
        return Response.ok((Object)propsJson).build();
    }

    public static class PropsResponse {
        private Map<String, String> props;

        public PropsResponse(Map<String, String> props) {
            this.props = props;
        }

        public Map<String, String> getProps() {
            return this.props;
        }
    }
}

