/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import netflix.adminresources.resources.MaskedResourceHelper;

@Path(value="/env")
@Produces(value={"application/json"})
@Beta
public class EnvironmentResource {
    @GET
    public Response getEnvironmentVars() {
        HashMap<String, String> envVarsMap = new HashMap<String, String>(System.getenv());
        Set<String> maskedProperties = MaskedResourceHelper.getMaskedPropertiesSet();
        for (String maskedResource : maskedProperties) {
            if (!envVarsMap.containsKey(maskedResource)) continue;
            envVarsMap.put(maskedResource, "**** MASKED ****");
        }
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String envJson = gson.toJson((Object)new EnvResponse(envVarsMap));
        return Response.ok((Object)envJson).build();
    }

    public static class EnvResponse {
        private Map<String, String> env;

        public EnvResponse(Map<String, String> env) {
            this.env = env;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }
    }
}

