/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import netflix.adminresources.resources.KaryonAdminResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jars")
@Produces(value={"application/json"})
@Beta
public class JarsInfoResource {
    private static final Logger logger = LoggerFactory.getLogger(JarsInfoResource.class);
    private static final String JAR_PATTERN = "^jar:file:(.+)!/META-INF/MANIFEST.MF$";
    private final List<JarManifest> jarManifests = JarsInfoResource.loadJarManifests();
    private final ArrayList<JarInfo> jarInfos = new ArrayList();

    public JarsInfoResource() {
        for (JarManifest jm : this.jarManifests) {
            this.jarInfos.add(jm.toJarInfo());
        }
    }

    @GET
    public Response getAllJarsInfo() {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String jarsJson = gson.toJson((Object)new JarsInfoResponse(this.jarInfos));
        return Response.ok((Object)jarsJson).build();
    }

    @GET
    @Path(value="/{id}")
    public Response getJarManifest(@PathParam(value="id") int jarId) {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new KaryonAdminResponse(this.jarManifests.get(jarId)));
        return Response.ok((Object)propsJson).build();
    }

    private static List<JarManifest> loadJarManifests() {
        ArrayList<JarManifest> jarManifests = new ArrayList<JarManifest>();
        Pattern pattern = Pattern.compile(JAR_PATTERN);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
            int id = 0;
            while (urls.hasMoreElements()) {
                URL manifestURL = urls.nextElement();
                InputStream is = manifestURL.openStream();
                String key = manifestURL.toString();
                Matcher matcher = pattern.matcher(key);
                if (matcher.matches()) {
                    key = matcher.group(1);
                }
                jarManifests.add(new JarManifest(id, key, new Manifest(is)));
                is.close();
                ++id;
            }
        }
        catch (Exception e) {
            logger.error("Failed to load environment jar information.", (Throwable)e);
        }
        return jarManifests;
    }

    private static class JarInfo {
        public static final String LIBRARY_OWNER = "Library-Owner";
        public static final String BUILD_DATE = "Build-Date";
        public static final String STATUS = "Status";
        public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
        public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
        public static final String SPECIFICATION_VERSION = "Specification-Version";
        public static final String UNAVAILABLE = "-";
        private final int id;
        private final String name;
        private final String libraryOwner;
        private final String buildDate;
        private final String status;
        private final String implementationVersion;
        private final String implementationTitle;
        private final String specificationVersion;

        private JarInfo(int id, String jar, Attributes mainAttributes) {
            this.id = id;
            this.name = jar;
            this.libraryOwner = JarInfo.valueOf(mainAttributes, LIBRARY_OWNER);
            this.buildDate = JarInfo.valueOf(mainAttributes, BUILD_DATE);
            this.status = JarInfo.valueOf(mainAttributes, STATUS);
            this.implementationTitle = JarInfo.valueOf(mainAttributes, IMPLEMENTATION_TITLE);
            this.implementationVersion = JarInfo.valueOf(mainAttributes, IMPLEMENTATION_VERSION);
            this.specificationVersion = JarInfo.valueOf(mainAttributes, SPECIFICATION_VERSION);
        }

        public String getStatus() {
            return this.status;
        }

        public String getLibraryOwner() {
            return this.libraryOwner;
        }

        public String getBuildDate() {
            return this.buildDate;
        }

        public String getName() {
            return this.name;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public String getImplementationTitle() {
            return this.implementationTitle;
        }

        public String getSpecificationVersion() {
            return this.specificationVersion;
        }

        private static String valueOf(Attributes mainAttributes, String tag) {
            String value = mainAttributes.getValue(tag);
            return value == null ? UNAVAILABLE : value;
        }
    }

    private static class JarManifest {
        private final int id;
        private final String jarName;
        private final Manifest manifest;

        private JarManifest(int id, String jarName, Manifest manifest) {
            this.id = id;
            this.jarName = jarName;
            this.manifest = manifest;
        }

        public String getJarName() {
            return this.jarName;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public JarInfo toJarInfo() {
            return new JarInfo(this.id, this.jarName, this.manifest.getMainAttributes());
        }
    }

    public static class JarsInfoResponse {
        private List<JarInfo> jars;

        public JarsInfoResponse(List<JarInfo> jarInfos) {
            this.jars = jarInfos;
        }

        public List<JarInfo> getJars() {
            return this.jars;
        }
    }
}

