/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources.jmx;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import netflix.adminresources.resources.jmx.DynaTreeNode;
import netflix.adminresources.resources.jmx.JmxService;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json", "text/html"})
@Path(value="/jmx")
public class JMXResource {
    private static final Logger LOG = LoggerFactory.getLogger(JMXResource.class);
    private static final String CURRENT_VALUE = "CurrentValue";
    private JmxService jmx;

    public JMXResource() {
        LOG.info("JMXResource created");
        this.jmx = JmxService.getInstance();
    }

    @GET
    public Response getMBeans(@QueryParam(value="key") @DefaultValue(value="root") String key, @QueryParam(value="mode") @DefaultValue(value="") String mode, @QueryParam(value="jsonp") @DefaultValue(value="") String jsonp) throws Exception {
        LOG.info("key" + key);
        DynaTreeNode root = new DynaTreeNode();
        for (String domain : this.jmx.getDomainList()) {
            root.putChild(this.jmx.getDomainTree(domain).setTitle(domain).setMode("domain"));
        }
        StringWriter out = new StringWriter();
        if (jsonp.isEmpty()) {
            root.getChildrenJSONArray().write((Writer)out);
        } else {
            out.append(jsonp).append("(");
            root.getChildrenJSONArray().write((Writer)out);
            out.append(");");
        }
        return Response.ok((Object)out.toString()).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache").header("Expires", (Object)"0").build();
    }

    @GET
    @Path(value="{key}")
    public Response getMBean(@PathParam(value="key") String key, @QueryParam(value="jsonp") @DefaultValue(value="") String jsonp) throws Exception {
        LOG.info("key: " + key);
        JSONObject json = new JSONObject();
        ObjectName name = new ObjectName(key);
        json.put("domain", (Object)name.getDomain());
        json.put("property", name.getKeyPropertyList());
        if (key.contains("*")) {
            JSONObject keys = new JSONObject();
            for (Map.Entry<String, Map<String, String>> attrs : this.jmx.getMBeanAttributesByRegex(key).entrySet()) {
                keys.put(attrs.getKey(), attrs.getValue());
            }
            json.put("attributes", (Object)keys);
            json.put("multikey", true);
        } else {
            json.put("attributes", this.jmx.getMBeanAttributes(key));
            json.put("multikey", false);
            MBeanOperationInfo[] operations = this.jmx.getMBeanOperations(key);
            JSONArray ar = new JSONArray();
            for (MBeanOperationInfo operation : operations) {
                JSONObject obj = new JSONObject();
                obj.put("name", (Object)operation.getName());
                obj.put("description", (Object)operation.getDescription());
                obj.put("returnType", (Object)operation.getReturnType());
                obj.put("impact", operation.getImpact());
                JSONArray params = new JSONArray();
                for (MBeanParameterInfo param : operation.getSignature()) {
                    JSONObject p = new JSONObject();
                    p.put("name", (Object)param.getName());
                    p.put("type", (Object)param.getType());
                    params.put((Object)p);
                }
                obj.put("params", (Object)params);
                ar.put((Object)obj);
            }
            json.put("operations", (Object)ar);
        }
        StringWriter out = new StringWriter();
        if (jsonp.isEmpty()) {
            json.write((Writer)out);
        } else {
            out.append(jsonp).append("(");
            json.write((Writer)out);
            out.append(");");
        }
        return Response.ok((Object)out.toString()).type("application/json").build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{key}/{op}")
    public Response invokeMbeanOperation(MultivaluedMap<String, String> formParams, @PathParam(value="key") String key, @QueryParam(value="jsonp") String jsonp, @PathParam(value="op") String name) throws Exception {
        LOG.info("invoke " + key + " op=" + name);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        TreeMap params = new TreeMap();
        for (Map.Entry entry : formParams.entrySet()) {
            if (((String)entry.getKey()).equals("op")) continue;
            if (((List)entry.getValue()).size() > 0) {
                params.put(entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            params.put(entry.getKey(), "");
        }
        ObjectName objName = new ObjectName(key);
        MBeanInfo info = mBeanServer.getMBeanInfo(objName);
        for (MBeanOperationInfo op : info.getOperations()) {
            if (!op.getName().equals(name)) continue;
            ArrayList<String> signature = new ArrayList<String>();
            for (MBeanParameterInfo s : op.getSignature()) {
                signature.add(s.getType());
            }
            Object result = mBeanServer.invoke(objName, name, params.values().toArray(new String[params.size()]), signature.toArray(new String[signature.size()]));
            JSONObject json = new JSONObject();
            json.put("key", (Object)key);
            json.put("operation", (Object)name);
            if (result != null) {
                json.put("response", (Object)result.toString());
            }
            json.put("type", (Object)op.getReturnType());
            StringWriter out = new StringWriter();
            if (jsonp.isEmpty()) {
                json.write((Writer)out);
            } else {
                out.append(jsonp).append("(");
                json.write((Writer)out);
                out.append(");");
            }
            return Response.ok((Object)out.toString()).type("application/json").build();
        }
        return Response.serverError().build();
    }

    @GET
    @Path(value="/mbeans")
    public Response getMBeansByRegex(@QueryParam(value="objNameRegex") String objNameRegex, @QueryParam(value="jsonp") @DefaultValue(value="") String jsonp) {
        try {
            ObjectName objNameForRegex = new ObjectName(objNameRegex);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> objs = mBeanServer.queryNames(objNameForRegex, null);
            JSONObject result = new JSONObject();
            for (ObjectName objName : objs) {
                JSONObject json = new JSONObject();
                try {
                    json.put("attributes", (Object)this.emitAttributes(objName));
                }
                catch (Exception e) {
                    json.put("attributes", (Object)this.emitAttributes(objName));
                }
                json.put("operations", (Object)this.emitOperations(objName));
                result.put(objName.getCanonicalName(), (Object)json);
            }
            StringWriter out = new StringWriter();
            if (jsonp.isEmpty()) {
                result.write((Writer)out);
            } else {
                out.append(jsonp).append("(");
                result.write((Writer)out);
                out.append(");");
            }
            return Response.ok((Object)out.toString()).type("application/json").build();
        }
        catch (Exception e) {
            LOG.error("Error while retrieving mbeans for regex:" + objNameRegex, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private JSONObject emitAttributes(ObjectName objName) throws Exception {
        MBeanAttributeInfo[] attrs;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objName);
        JSONObject resp = new JSONObject();
        if (mBeanInfo != null && (attrs = mBeanInfo.getAttributes()) != null) {
            ArrayList<String> attrNames = new ArrayList<String>(attrs.length);
            for (MBeanAttributeInfo attr : attrs) {
                attrNames.add(attr.getName());
            }
            AttributeList attrList = mBeanServer.getAttributes(objName, attrNames.toArray(new String[0]));
            for (Attribute attr : attrList.asList()) {
                CompositeDataSupport compositeValue;
                Object value = attr.getValue();
                String attrName = attr.getName();
                if (attrName == null || value == null) continue;
                String attrValue = null;
                if (value instanceof CompositeDataSupport && (compositeValue = (CompositeDataSupport)value) != null) {
                    try {
                        if (compositeValue.containsKey(CURRENT_VALUE)) {
                            Object curValue = compositeValue.get(CURRENT_VALUE);
                            attrValue = curValue == null ? "null" : curValue.toString();
                        }
                    }
                    catch (Exception e) {
                        attrValue = compositeValue.toString();
                    }
                }
                if (attrValue == null) {
                    attrValue = value.toString();
                }
                resp.put(attrName, (Object)(attrValue == null ? "null" : attrValue));
            }
        }
        return resp;
    }

    private JSONArray emitOperations(ObjectName objName) throws Exception {
        MBeanOperationInfo[] operations;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objName);
        JSONArray ar = new JSONArray();
        for (MBeanOperationInfo operation : operations = mBeanInfo.getOperations()) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)operation.getName());
            obj.put("description", (Object)operation.getDescription());
            obj.put("returnType", (Object)operation.getReturnType());
            obj.put("impact", operation.getImpact());
            JSONArray params = new JSONArray();
            for (MBeanParameterInfo param : operation.getSignature()) {
                JSONObject p = new JSONObject();
                p.put("name", (Object)param.getName());
                p.put("type", (Object)param.getType());
                params.put((Object)p);
            }
            obj.put("params", (Object)params);
            ar.put((Object)obj);
        }
        return ar;
    }
}

