/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.resources.jmx;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import netflix.adminresources.resources.jmx.DynaTreeNode;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxService {
    private static final Logger LOG = LoggerFactory.getLogger(JmxService.class);
    private static final String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private static final String CURRENT_VALUE = "CurrentValue";
    private static final String MODE_DOMAIN = "domain";
    private static final String MODE_INNER = "inner";
    private static final String MODE_LEAF = "leaf";
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static Pattern csvRE = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");

    private JmxService() {
    }

    public static JmxService getInstance() {
        return Holder.instance;
    }

    public List<String> getDomainList() {
        return Lists.newArrayList((Object[])this.mBeanServer.getDomains());
    }

    public DynaTreeNode getDomainTree(String domainName) {
        DynaTreeNode domainNode = new DynaTreeNode().setTitle(domainName).setKey(domainName).setMode(MODE_DOMAIN);
        try {
            ObjectName name = new ObjectName(domainName + ":*");
            Set<ObjectName> objs = this.mBeanServer.queryNames(name, null);
            for (ObjectName objName : objs) {
                MBeanInfo info = this.mBeanServer.getMBeanInfo(objName);
                Matcher m = csvRE.matcher(objName.getKeyPropertyListString());
                DynaTreeNode node = domainNode;
                StringBuilder innerKey = new StringBuilder();
                innerKey.append(domainName).append(":");
                while (m.find()) {
                    String title = StringUtils.removeEnd((String)m.group(), (String)",");
                    String key = StringUtils.substringBefore((String)title, (String)"=");
                    String value = StringUtils.substringAfter((String)title, (String)"=");
                    value = StringUtils.removeStart((String)value, (String)"\"");
                    value = StringUtils.removeEnd((String)value, (String)"\"");
                    innerKey.append(title).append(",");
                    DynaTreeNode next = node.getChild(value);
                    if (next == null) {
                        next = new DynaTreeNode().setTitle(value).setMode(MODE_INNER).setKey(innerKey.toString() + "*").setNoLink(false);
                        node.putChild(next);
                    }
                    node = next;
                }
                node.setKey(objName.getCanonicalName()).setMode(MODE_LEAF);
                if (info.getAttributes() == null && info.getOperations() == null && info.getNotifications() == null) continue;
                node.setNoLink(false);
            }
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Exception in getDomainTree ", (Throwable)e);
        }
        catch (IntrospectionException e) {
            LOG.error("Exception in getDomainTree ", (Throwable)e);
        }
        catch (ReflectionException e) {
            LOG.error("Exception in getDomainTree ", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            LOG.error("Exception in getDomainTree ", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error("Exception in getDomainTree ", (Throwable)e);
        }
        return domainNode;
    }

    public List<String> getDomainKeys(String domainName) {
        return this.getKeysFromRegex(domainName + ":*");
    }

    public List<String> getKeysFromRegex(String regex) {
        ArrayList keys = Lists.newArrayList();
        try {
            ObjectName name = new ObjectName(regex);
            Set<ObjectName> objs = this.mBeanServer.queryNames(name, null);
            for (ObjectName objName : objs) {
                MBeanInfo info = this.mBeanServer.getMBeanInfo(objName);
                keys.add(objName.getCanonicalName());
            }
        }
        catch (Exception e) {
            LOG.error("Exception in getKeysFromRegex ", (Throwable)e);
        }
        return keys;
    }

    public Map<String, Map<String, String>> getMBeanAttributesByRegex(String regex) throws Exception {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ObjectName name = new ObjectName(regex);
        Set<ObjectName> objs = this.mBeanServer.queryNames(name, null);
        for (ObjectName objName : objs) {
            result.put(objName.getCanonicalName(), this.getMBeanAttributes(objName));
        }
        return result;
    }

    public Map<String, String> getMBeanAttributes(String key) throws Exception {
        return this.getMBeanAttributes(new ObjectName(key));
    }

    private Map<String, String> getMBeanAttributes(ObjectName objName) throws Exception {
        MBeanAttributeInfo[] attrs;
        LinkedHashMap response = Maps.newLinkedHashMap();
        MBeanInfo mBeanInfo = this.mBeanServer.getMBeanInfo(objName);
        if (mBeanInfo != null && (attrs = mBeanInfo.getAttributes()) != null) {
            ArrayList attrNames = Lists.newArrayList();
            for (MBeanAttributeInfo attr : attrs) {
                attrNames.add(attr.getName());
            }
            AttributeList attrList = this.mBeanServer.getAttributes(objName, attrNames.toArray(new String[0]));
            for (Attribute attr : attrList.asList()) {
                String attrName = attr.getName();
                Object value = attr.getValue();
                String attrValue = null;
                if (value != null) {
                    CompositeDataSupport compositeValue;
                    if (value instanceof CompositeDataSupport && (compositeValue = (CompositeDataSupport)value) != null) {
                        try {
                            if (compositeValue.containsKey(CURRENT_VALUE)) {
                                Object curValue = compositeValue.get(CURRENT_VALUE);
                                attrValue = curValue == null ? "null" : curValue.toString();
                            }
                        }
                        catch (Exception e) {
                            attrValue = compositeValue.toString();
                        }
                    }
                    if (attrValue == null) {
                        attrValue = value.toString();
                    }
                } else {
                    value = "none";
                }
                response.put(attrName, attrValue);
            }
        }
        return response;
    }

    public MBeanOperationInfo[] getMBeanOperations(String name) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(new ObjectName(name));
        return mBeanInfo.getOperations();
    }

    private static class Holder {
        private static final JmxService instance = new JmxService();

        private Holder() {
        }
    }
}

