/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.tableview;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.ws.rs.core.MultivaluedMap;
import netflix.adminresources.tableview.TableViewResource;

public class DataTableHelper {
    public static JsonObject buildOutput(TableViewResource tableViewResource, MultivaluedMap<String, String> queryParams) {
        JsonObject output = new JsonObject();
        DataTableHelper.applyQueryParams(tableViewResource, queryParams);
        JsonArray data = tableViewResource.getData();
        String sEcho = (String)queryParams.getFirst((Object)"sEcho");
        output.addProperty("iTotalRecords", (Number)tableViewResource.getTotalNumOfRecords());
        output.addProperty("iTotalDisplayRecords", (Number)tableViewResource.getFilteredNumOfRecords());
        output.addProperty("sEcho", sEcho);
        output.add("aaData", (JsonElement)data);
        return output;
    }

    private static void applyQueryParams(TableViewResource resource, MultivaluedMap<String, String> queryParams) {
        String allColsSearch = (String)queryParams.getFirst((Object)"sSearch");
        String displayStart = (String)queryParams.getFirst((Object)"iDisplayStart");
        String displayLen = (String)queryParams.getFirst((Object)"iDisplayLength");
        String sortColumnIndex = (String)queryParams.getFirst((Object)"iSortCol_0");
        String sortColumnDir = (String)queryParams.getFirst((Object)"sSortDir_0");
        if (sortColumnDir == null || sortColumnIndex == null) {
            sortColumnDir = "asc";
            sortColumnIndex = "0";
        }
        int colIndex = Integer.parseInt(sortColumnIndex);
        String sortColumnName = resource.getColumns().get(colIndex);
        if (displayLen != null && displayStart != null) {
            int iDisplayLen = Integer.parseInt(displayLen);
            int iDisplayStart = Integer.parseInt(displayStart);
            resource.setAllColumnsSearchTerm(allColsSearch).setCurrentPageInfo(iDisplayStart, iDisplayLen).enableColumnSort(sortColumnName, !sortColumnDir.equalsIgnoreCase("asc"));
        }
    }
}

