/*
 * Decompiled with CFR 0.152.
 */
package netflix.adminresources.tableview;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import netflix.adminresources.resources.PropertiesHelper;
import netflix.adminresources.resources.model.Property;
import netflix.adminresources.tableview.TableViewResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsTableView
implements TableViewResource {
    private static final Logger LOG = LoggerFactory.getLogger(PropsTableView.class);
    private final Map<String, Column> columnMap = new LinkedHashMap<String, Column>();
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    private String allColumnSearchTerm;
    private PageInfo currentPage;
    private int totalRecords;
    private int numFilteredRecords;

    public PropsTableView() {
        LOG.debug("Creating a new propsTableViewResource ");
        Column keyCol = new Column();
        keyCol.name = KEY;
        Column valCol = new Column();
        valCol.name = VALUE;
        this.columnMap.put(KEY, keyCol);
        this.columnMap.put(VALUE, valCol);
    }

    @Override
    public List<String> getColumns() {
        return new ArrayList<String>(this.columnMap.keySet());
    }

    @Override
    public TableViewResource setColumnSearchTerm(String column, String term) {
        if (this.columnMap.containsKey(column)) {
            this.columnMap.get((Object)column).searchTerm = term;
        }
        return this;
    }

    @Override
    public TableViewResource setAllColumnsSearchTerm(String term) {
        this.allColumnSearchTerm = term;
        return this;
    }

    @Override
    public TableViewResource enableColumnSort(String column, boolean isDescending) {
        if (this.columnMap.containsKey(column)) {
            this.columnMap.get((Object)column).isDescendingSort = isDescending;
            this.columnMap.get((Object)column).enableSort = true;
        }
        return this;
    }

    @Override
    public JsonArray getData() {
        JsonArray props = new JsonArray();
        List<Property> properties = PropertiesHelper.getAllProperties();
        this.numFilteredRecords = this.totalRecords = properties.size();
        List<Property> propsFiltered = this.applyFilter(properties);
        List<Property> propsSorted = this.applySorting(propsFiltered);
        List<Property> propsCurrentPage = this.applyPagination(propsSorted);
        for (Property property : propsCurrentPage) {
            JsonArray propArr = new JsonArray();
            JsonPrimitive propName = new JsonPrimitive(property.getName());
            JsonPrimitive propValue = new JsonPrimitive(property.getValue());
            propArr.add((JsonElement)propName);
            propArr.add((JsonElement)propValue);
            props.add((JsonElement)propArr);
        }
        return props;
    }

    @Override
    public int getTotalNumOfRecords() {
        return this.totalRecords;
    }

    @Override
    public int getFilteredNumOfRecords() {
        return this.numFilteredRecords;
    }

    @Override
    public TableViewResource setCurrentPageInfo(int startIndex, int count) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.count = count;
        pageInfo.startIndex = startIndex;
        this.currentPage = pageInfo;
        return this;
    }

    private List<Property> applyPagination(List<Property> properties) {
        if (!this.isPaginated()) {
            return properties;
        }
        ArrayList propertyList = Lists.newArrayList();
        int index = 0;
        int endIndex = this.currentPage.startIndex + this.currentPage.count;
        for (Property property : properties) {
            if (index >= this.currentPage.startIndex && index < endIndex) {
                propertyList.add(property);
            }
            if (index >= endIndex) break;
            ++index;
        }
        return propertyList;
    }

    private boolean isPaginated() {
        return this.currentPage != null;
    }

    private List<Property> applyFilter(List<Property> propsCurrentPage) {
        if (this.allColumnSearchTerm != null && !this.allColumnSearchTerm.isEmpty()) {
            return this.applyAllColumnsFilter(propsCurrentPage);
        }
        if (this.columnSearchTermExists()) {
            return this.applyColumnFilters(propsCurrentPage);
        }
        return propsCurrentPage;
    }

    private List<Property> applyColumnFilters(List<Property> propsCurrentPage) {
        String propKeySearchTerm = this.getPropKeySearchTerm();
        String propValueSearchTerm = this.getPropValueSearchTerm();
        ArrayList filteredList = Lists.newArrayList();
        int index = 0;
        for (Property property : propsCurrentPage) {
            String propName = property.getName().toLowerCase();
            String propValue = property.getValue().toLowerCase();
            boolean matched = true;
            if (propKeySearchTerm != null) {
                matched = propName.contains(propKeySearchTerm);
            }
            if (propValueSearchTerm != null) {
                boolean bl = matched = matched && propValue.contains(propValueSearchTerm);
            }
            if (!matched) continue;
            filteredList.add(property);
            ++index;
        }
        this.numFilteredRecords = index;
        return filteredList;
    }

    private List<Property> applyAllColumnsFilter(List<Property> propsCurrentPage) {
        String searchTermLowerCase = this.allColumnSearchTerm.toLowerCase();
        ArrayList filteredList = Lists.newArrayList();
        int index = 0;
        for (Property property : propsCurrentPage) {
            String propName = property.getName().toLowerCase();
            String propValue = property.getValue().toLowerCase();
            if (!propName.contains(searchTermLowerCase) && !propValue.contains(searchTermLowerCase)) continue;
            filteredList.add(property);
            ++index;
        }
        this.numFilteredRecords = index;
        return filteredList;
    }

    private boolean columnSearchTermExists() {
        for (Map.Entry<String, Column> columnEntry : this.columnMap.entrySet()) {
            Column col = columnEntry.getValue();
            if (col.searchTerm == null) continue;
            return true;
        }
        return false;
    }

    private String getPropKeySearchTerm() {
        return this.columnMap.get((Object)KEY).searchTerm;
    }

    private String getPropValueSearchTerm() {
        return this.columnMap.get((Object)VALUE).searchTerm;
    }

    private List<Property> applySorting(List<Property> propsFiltered) {
        Column sortOnColumn = null;
        for (Column column : this.columnMap.values()) {
            if (!column.enableSort) continue;
            sortOnColumn = column;
            break;
        }
        if (sortOnColumn != null) {
            final boolean sortOnKey = sortOnColumn.name.equals(KEY);
            final boolean isDescending = sortOnColumn.isDescendingSort;
            Collections.sort(propsFiltered, new Comparator<Property>(){

                @Override
                public int compare(Property property, Property property2) {
                    if (sortOnKey) {
                        if (isDescending) {
                            return property2.getName().compareTo(property.getName());
                        }
                        return property.getName().compareTo(property2.getName());
                    }
                    if (isDescending) {
                        return property2.getValue().compareTo(property.getValue());
                    }
                    return property.getValue().compareTo(property2.getValue());
                }
            });
        }
        return propsFiltered;
    }

    private static class PageInfo {
        int startIndex;
        int count;

        private PageInfo() {
        }
    }

    private static class Column {
        String name;
        String searchTerm;
        boolean enableSort;
        boolean isDescendingSort;

        private Column() {
        }
    }
}

