/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.google.inject.Injector;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.Arrays;
import netflix.karyon.KaryonServer;

abstract class AbstractKaryonServer
implements KaryonServer {
    protected final BootstrapModule[] bootstrapModules;
    protected LifecycleManager lifecycleManager;
    protected Injector injector;

    public AbstractKaryonServer(BootstrapModule ... bootstrapModules) {
        this.bootstrapModules = bootstrapModules;
    }

    @Override
    public final void start() {
        this.startWithAdditionalBootstrapModules(new BootstrapModule[0]);
    }

    public final void startWithAdditionalBootstrapModules(BootstrapModule ... additionalBootstrapModules) {
        BootstrapModule[] applicableBootstrapModules = this.bootstrapModules;
        if (null != additionalBootstrapModules && additionalBootstrapModules.length != 0) {
            applicableBootstrapModules = Arrays.copyOf(this.bootstrapModules, this.bootstrapModules.length + additionalBootstrapModules.length);
            System.arraycopy(additionalBootstrapModules, 0, applicableBootstrapModules, this.bootstrapModules.length, additionalBootstrapModules.length);
        }
        this.injector = this.newInjector(applicableBootstrapModules);
        this.startLifecycleManager();
        this._start();
    }

    protected abstract void _start();

    @Override
    public void shutdown() {
        if (this.lifecycleManager != null) {
            this.lifecycleManager.close();
        }
    }

    @Override
    public void startAndWaitTillShutdown() {
        this.start();
        this.waitTillShutdown();
    }

    protected abstract Injector newInjector(BootstrapModule ... var1);

    protected void startLifecycleManager() {
        this.lifecycleManager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        try {
            this.lifecycleManager.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

