/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.google.common.collect.Lists;
import com.google.inject.Module;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.protocol.udp.server.UdpServer;
import io.reactivex.netty.server.AbstractServer;
import io.reactivex.netty.server.RxServer;
import java.util.Collection;
import netflix.karyon.AbstractKaryonServer;
import netflix.karyon.KaryonServer;
import netflix.karyon.KaryonServerBackedServer;
import netflix.karyon.MainClassBasedServer;
import netflix.karyon.RxNettyServerBackedServer;
import netflix.karyon.transport.KaryonTransport;
import rx.Observable;

public final class Karyon {
    private Karyon() {
    }

    public static KaryonServer forRequestHandler(int port, RequestHandler<ByteBuf, ByteBuf> handler, Module ... modules) {
        return Karyon.forRequestHandler(port, handler, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forRequestHandler(int port, final RequestHandler<ByteBuf, ByteBuf> handler, BootstrapModule ... bootstrapModules) {
        HttpServer httpServer = KaryonTransport.newHttpServer((int)port, (RequestHandler)new RequestHandler<ByteBuf, ByteBuf>(){

            public Observable<Void> handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                return handler.handle(request, response);
            }
        });
        return new RxNettyServerBackedServer((AbstractServer)httpServer, bootstrapModules);
    }

    public static KaryonServer forTcpConnectionHandler(int port, ConnectionHandler<ByteBuf, ByteBuf> handler, Module ... modules) {
        return Karyon.forTcpConnectionHandler(port, handler, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forTcpConnectionHandler(int port, ConnectionHandler<ByteBuf, ByteBuf> handler, BootstrapModule ... bootstrapModules) {
        RxServer server = (RxServer)RxNetty.newTcpServerBuilder((int)port, handler).build();
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forUdpConnectionHandler(int port, ConnectionHandler<ByteBuf, ByteBuf> handler, Module ... modules) {
        return Karyon.forUdpConnectionHandler(port, handler, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forUdpConnectionHandler(int port, ConnectionHandler<ByteBuf, ByteBuf> handler, BootstrapModule ... bootstrapModules) {
        UdpServer server = (UdpServer)RxNetty.newUdpServerBuilder((int)port, handler).build();
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forTcpServer(RxServer<?, ?> server, Module ... modules) {
        return Karyon.forTcpServer(server, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forTcpServer(RxServer<?, ?> server, BootstrapModule ... bootstrapModules) {
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forHttpServer(HttpServer<?, ?> server, Module ... modules) {
        return Karyon.forHttpServer(server, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forHttpServer(HttpServer<?, ?> server, BootstrapModule ... bootstrapModules) {
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forWebSocketServer(RxServer<? extends WebSocketFrame, ? extends WebSocketFrame> server, Module ... modules) {
        return Karyon.forWebSocketServer(server, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forWebSocketServer(RxServer<? extends WebSocketFrame, ? extends WebSocketFrame> server, BootstrapModule ... bootstrapModules) {
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forUdpServer(UdpServer<?, ?> server, Module ... modules) {
        return Karyon.forUdpServer(server, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forUdpServer(UdpServer<?, ?> server, BootstrapModule ... bootstrapModules) {
        return new RxNettyServerBackedServer((AbstractServer)server, bootstrapModules);
    }

    public static KaryonServer forServer(KaryonServer server, Module ... modules) {
        return Karyon.forServer(server, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forServer(KaryonServer server, BootstrapModule ... bootstrapModules) {
        return new KaryonServerBackedServer((AbstractKaryonServer)server, bootstrapModules);
    }

    public static KaryonServer forApplication(Class<?> mainClass, Module ... modules) {
        return Karyon.forApplication(mainClass, Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forApplication(Class<?> mainClass, BootstrapModule ... bootstrapModules) {
        return new MainClassBasedServer(mainClass, bootstrapModules);
    }

    public static KaryonServer forModules(Module ... modules) {
        return Karyon.forSuites(Karyon.toBootstrapModule(modules));
    }

    public static KaryonServer forSuites(BootstrapModule ... bootstrapModules) {
        return new MainClassBasedServer(KaryonServer.class, bootstrapModules);
    }

    public static BootstrapModule toBootstrapModule(final Module ... modules) {
        if (null == modules) {
            return null;
        }
        return new BootstrapModule(){

            public void configure(BootstrapBinder binder) {
                binder.includeModules(modules);
            }
        };
    }

    @SafeVarargs
    public static BootstrapModule toBootstrapModule(final Class<? extends Module> ... moduleClasses) {
        if (null == moduleClasses) {
            return null;
        }
        return new BootstrapModule(){

            public void configure(BootstrapBinder binder) {
                binder.include((Collection)Lists.newArrayList((Object[])moduleClasses));
            }
        };
    }

    public static BootstrapModule toBootstrapModule(final Class<? extends Module> moduleClass) {
        if (null == moduleClass) {
            return null;
        }
        return new BootstrapModule(){

            public void configure(BootstrapBinder binder) {
                binder.include(moduleClass);
            }
        };
    }
}

