/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjectorMode;
import javax.inject.Inject;
import netflix.karyon.KaryonBootstrap;
import netflix.karyon.health.AlwaysHealthyHealthCheck;
import netflix.karyon.health.HealthCheckHandler;
import netflix.karyon.health.HealthCheckInvocationStrategy;
import netflix.karyon.health.SyncHealthCheckInvocationStrategy;

public class KaryonBootstrapModule
implements BootstrapModule {
    private final Class<? extends HealthCheckHandler> healthcheckHandlerClass;
    private final HealthCheckHandler healthcheckHandler;
    private final KaryonBootstrap karyonBootstrap;

    public KaryonBootstrapModule() {
        this((HealthCheckHandler)null);
    }

    public KaryonBootstrapModule(HealthCheckHandler healthcheckHandler) {
        this.healthcheckHandler = null == healthcheckHandler ? new AlwaysHealthyHealthCheck() : healthcheckHandler;
        this.healthcheckHandlerClass = null;
        this.karyonBootstrap = null;
    }

    public KaryonBootstrapModule(Class<? extends HealthCheckHandler> healthcheckHandlerClass) {
        this.healthcheckHandler = null;
        this.healthcheckHandlerClass = healthcheckHandlerClass;
        this.karyonBootstrap = null;
    }

    @Inject
    KaryonBootstrapModule(KaryonBootstrap karyonBootstrap) {
        this.karyonBootstrap = karyonBootstrap;
        this.healthcheckHandlerClass = karyonBootstrap.healthcheck();
        this.healthcheckHandler = null;
    }

    public void configure(BootstrapBinder bootstrapBinder) {
        bootstrapBinder.inMode(LifecycleInjectorMode.SIMULATED_CHILD_INJECTORS);
        bootstrapBinder.include((Module)new AbstractModule(){

            protected void configure() {
                KaryonBootstrapModule.this.bindHealthCheck((LinkedBindingBuilder<HealthCheckHandler>)this.bind(HealthCheckHandler.class));
                KaryonBootstrapModule.bindHealthCheckInvocationStrategy((AnnotatedBindingBuilder<HealthCheckInvocationStrategy>)this.bind(HealthCheckInvocationStrategy.class));
            }
        });
    }

    private static void bindHealthCheckInvocationStrategy(AnnotatedBindingBuilder<HealthCheckInvocationStrategy> bindingBuilder) {
        bindingBuilder.to(SyncHealthCheckInvocationStrategy.class);
    }

    protected void bindHealthCheck(LinkedBindingBuilder<HealthCheckHandler> bindingBuilder) {
        if (null != this.healthcheckHandlerClass) {
            bindingBuilder.to(this.healthcheckHandlerClass);
        } else {
            bindingBuilder.toInstance((Object)this.healthcheckHandler);
        }
    }
}

