/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.netflix.governator.guice.BootstrapModule;
import netflix.karyon.Karyon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KaryonRunner {
    private static final Logger logger = LoggerFactory.getLogger(KaryonRunner.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: " + KaryonRunner.class.getCanonicalName() + " <main classs name>");
            System.exit(-1);
        }
        String mainClassName = args[0];
        System.out.println("Using main class: " + mainClassName);
        try {
            Karyon.forApplication(Class.forName(mainClassName), (BootstrapModule[])null).startAndWaitTillShutdown();
        }
        catch (ClassNotFoundException e) {
            System.out.println("Main class: " + mainClassName + " not found.");
            System.exit(-1);
        }
        catch (Exception e) {
            logger.error("Error while starting karyon server.", (Throwable)e);
            System.exit(-1);
        }
        System.exit(0);
    }
}

