/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.google.inject.Injector;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjector;
import java.util.concurrent.CountDownLatch;
import netflix.karyon.AbstractKaryonServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MainClassBasedServer
extends AbstractKaryonServer {
    private static final Logger logger = LoggerFactory.getLogger(MainClassBasedServer.class);
    private final Class<?> mainClass;

    protected MainClassBasedServer(Class<?> mainClass, BootstrapModule ... bootstrapModules) {
        super(bootstrapModules);
        this.mainClass = mainClass;
    }

    @Override
    public void waitTillShutdown() {
        final CountDownLatch shutdownFinished = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MainClassBasedServer.this.shutdown();
                    logger.info("Leaving main loop - shutdown finished.");
                }
                finally {
                    shutdownFinished.countDown();
                }
            }
        });
        try {
            shutdownFinished.await();
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for shutdown.", (Throwable)e);
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _start() {
    }

    @Override
    protected Injector newInjector(BootstrapModule ... applicableBootstrapModules) {
        return LifecycleInjector.bootstrap(this.mainClass, (BootstrapModule[])applicableBootstrapModules);
    }
}

