/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import netflix.karyon.Karyon;
import netflix.karyon.ShutdownListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;

public class ShutdownModule
extends AbstractModule {
    public static final int DEFAULT_PORT = 7002;
    private final int port;

    @Inject
    public ShutdownModule() {
        this.port = 7002;
    }

    protected ShutdownModule(int port) {
        this.port = port;
    }

    protected void configure() {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)"shutdownPort")).toInstance((Object)this.port);
        this.bind(ShutdownServer.class).asEagerSingleton();
    }

    protected LinkedBindingBuilder<Action0> bindBeforeShutdownAction() {
        return this.bind(Action0.class).annotatedWith((Annotation)Names.named((String)"beforeShutdownAction"));
    }

    protected LinkedBindingBuilder<Action0> bindAfterShutdownAction() {
        return this.bind(Action0.class).annotatedWith((Annotation)Names.named((String)"afterShutdownAction"));
    }

    public static BootstrapModule asBootstrapModule() {
        return ShutdownModule.asBootstrapModule(7002);
    }

    public static BootstrapModule asBootstrapModule(int port) {
        return Karyon.toBootstrapModule(new Module[]{new ShutdownModule(port)});
    }

    @Singleton
    public static class ShutdownServer {
        private static final Logger logger = LoggerFactory.getLogger(ShutdownServer.class);
        @Inject
        @Named(value="shutdownPort")
        private int port;
        @Inject(optional=true)
        @Named(value="beforeShutdownAction")
        private Action0 beforeAction;
        @Inject(optional=true)
        @Named(value="afterShutdownAction")
        private Action0 afterAction;
        @Inject
        private LifecycleManager lifeCycleManager;
        private ShutdownListener shutdownListener;

        @PostConstruct
        public void start() {
            this.shutdownListener = new ShutdownListener(this.port, new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void call() {
                    logger.info("Shutdown request received on port {}; stopping all services...", (Object)ShutdownServer.this.port);
                    try {
                        ShutdownServer.this.runShutdownCommands();
                    }
                    catch (Exception e) {
                        logger.error("Errors during shutdown", (Throwable)e);
                    }
                    finally {
                        try {
                            ShutdownServer.this.shutdownListener.shutdown();
                        }
                        catch (Exception e) {
                            logger.error("Errors during stopping shutdown listener", (Throwable)e);
                        }
                    }
                }
            });
            this.shutdownListener.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runShutdownCommands() {
            try {
                if (this.beforeAction != null) {
                    this.beforeAction.call();
                }
            }
            finally {
                try {
                    this.lifeCycleManager.close();
                }
                finally {
                    if (this.afterAction != null) {
                        this.afterAction.call();
                    }
                }
            }
        }
    }
}

