/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import java.lang.annotation.Annotation;

public abstract class AbstractServerModule<I, O, B extends ServerConfigBuilder>
extends AbstractModule {
    protected final Named nameAnnotation;
    protected final Class<I> iType;
    protected final Class<O> oType;
    protected final Key<PipelineConfigurator> pipelineConfiguratorKey;
    protected final Key<ServerConfig> serverConfigKey;
    protected final B serverConfigBuilder;

    protected AbstractServerModule(String moduleName, Class<I> iType, Class<O> oType) {
        this.nameAnnotation = Names.named((String)moduleName);
        this.iType = iType;
        this.oType = oType;
        this.pipelineConfiguratorKey = Key.get(PipelineConfigurator.class, (Annotation)this.nameAnnotation);
        this.serverConfigKey = Key.get(ServerConfig.class, (Annotation)this.nameAnnotation);
        this.serverConfigBuilder = this.newServerConfigBuilder();
    }

    protected abstract void configureServer();

    protected abstract B newServerConfigBuilder();

    protected LinkedBindingBuilder<PipelineConfigurator> bindPipelineConfigurator() {
        return this.bind(this.pipelineConfiguratorKey);
    }

    protected B server() {
        return this.serverConfigBuilder;
    }

    public static class ServerConfigBuilder<B extends ServerConfigBuilder, C extends ServerConfig> {
        protected int port = 8080;

        public B port(int port) {
            this.port = port;
            return (B)this;
        }

        public C build() {
            return (C)new ServerConfig(this.port);
        }
    }

    public static class ServerConfig {
        private final int port;

        public ServerConfig(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }
    }
}

