/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import com.google.inject.Injector;
import io.netty.handler.codec.http.HttpMethod;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import java.util.ArrayList;
import java.util.List;
import netflix.karyon.transport.http.HttpKeyEvaluationContext;
import netflix.karyon.transport.http.MethodConstraintKey;
import netflix.karyon.transport.http.RegexUriConstraintKey;
import netflix.karyon.transport.http.ServletStyleUriConstraintKey;
import netflix.karyon.transport.interceptor.AbstractAttacher;
import netflix.karyon.transport.interceptor.AbstractInterceptorSupport;
import netflix.karyon.transport.interceptor.DuplexInterceptor;
import netflix.karyon.transport.interceptor.InboundInterceptor;
import netflix.karyon.transport.interceptor.InterceptorHolder;
import netflix.karyon.transport.interceptor.InterceptorKey;
import netflix.karyon.transport.interceptor.OutboundInterceptor;
import rx.functions.Action1;

public class GovernatorHttpInterceptorSupport<I, O>
extends AbstractInterceptorSupport<HttpServerRequest<I>, HttpServerResponse<O>, HttpKeyEvaluationContext, GovernatorHttpAttacher<I, O>, GovernatorHttpInterceptorSupport<I, O>> {
    protected final List<HttpInClassHolder<I, O>> inboundInterceptorClasses = new ArrayList<HttpInClassHolder<I, O>>();
    protected final List<HttpOutClassHolder<I, O>> outboundInterceptorClasses = new ArrayList<HttpOutClassHolder<I, O>>();
    private Action1<GovernatorHttpInterceptorSupport<I, O>> finishListener;

    protected GovernatorHttpAttacher<I, O> newAttacher(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
        return new GovernatorHttpAttacher(this, key);
    }

    public GovernatorHttpAttacher<I, O> forUri(String uri) {
        if (null == uri || uri.isEmpty()) {
            throw new IllegalArgumentException("Uri can not be null or empty.");
        }
        return (GovernatorHttpAttacher)this.getAttacherForKey((InterceptorKey)new ServletStyleUriConstraintKey(uri, ""));
    }

    public GovernatorHttpAttacher<I, O> forUriRegex(String uriRegEx) {
        if (null == uriRegEx || uriRegEx.isEmpty()) {
            throw new IllegalArgumentException("Uri regular expression can not be null or empty.");
        }
        return (GovernatorHttpAttacher)this.getAttacherForKey((InterceptorKey)new RegexUriConstraintKey(uriRegEx));
    }

    public GovernatorHttpAttacher<I, O> forHttpMethod(HttpMethod method) {
        if (null == method) {
            throw new IllegalArgumentException("Uri can not be null or empty.");
        }
        return (GovernatorHttpAttacher)this.getAttacherForKey((InterceptorKey)new MethodConstraintKey(method));
    }

    public GovernatorHttpInterceptorSupport<I, O> finish(Injector injector) {
        if (!this.finished) {
            for (HttpInClassHolder<I, O> httpInClassHolder : this.inboundInterceptorClasses) {
                HttpInboundHolder ins = new HttpInboundHolder(httpInClassHolder.getKey());
                for (Class interceptor : httpInClassHolder.getInterceptors()) {
                    ins.addIn((InboundInterceptor)injector.getInstance(interceptor));
                }
                this.inboundInterceptors.add(ins.buildHolder());
            }
            for (HttpOutClassHolder httpOutClassHolder : this.outboundInterceptorClasses) {
                HttpOutboundHolder outs = new HttpOutboundHolder(httpOutClassHolder.getKey());
                for (Class interceptor : httpOutClassHolder.getInterceptors()) {
                    outs.addOut((OutboundInterceptor)injector.getInstance(interceptor));
                }
                this.outboundInterceptors.add(outs.buildHolder());
            }
            this._finish();
            this.finished = true;
            if (null != this.finishListener) {
                this.finishListener.call((Object)this);
            }
        }
        return this;
    }

    public void setFinishListener(Action1<GovernatorHttpInterceptorSupport<I, O>> finishListener) {
        this.finishListener = finishListener;
    }

    private static class HttpOutClassHolder<I, O>
    extends InterceptorHolder<HttpServerRequest<I>, HttpKeyEvaluationContext, Class<? extends OutboundInterceptor<HttpServerResponse<O>>>> {
        private HttpOutClassHolder(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key, List<Class<? extends OutboundInterceptor<HttpServerResponse<O>>>> interceptors) {
            super(key, interceptors);
        }
    }

    private static class HttpInClassHolder<I, O>
    extends InterceptorHolder<HttpServerRequest<I>, HttpKeyEvaluationContext, Class<? extends InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> {
        private HttpInClassHolder(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key, List<Class<? extends InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> interceptors) {
            super(key, interceptors);
        }
    }

    private static class HttpOutboundHolder<I, O> {
        private final InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key;
        private final List<OutboundInterceptor<HttpServerResponse<O>>> interceptors;

        private HttpOutboundHolder(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
            this.key = key;
            this.interceptors = new ArrayList<OutboundInterceptor<HttpServerResponse<O>>>();
        }

        private void addOut(OutboundInterceptor<HttpServerResponse<O>> interceptor) {
            this.interceptors.add(interceptor);
        }

        private InterceptorHolder<HttpServerRequest<I>, HttpKeyEvaluationContext, OutboundInterceptor<HttpServerResponse<O>>> buildHolder() {
            return new InterceptorHolder(this.key, this.interceptors);
        }
    }

    private static class HttpInboundHolder<I, O> {
        private final InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key;
        private final List<InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>> interceptors;

        private HttpInboundHolder(InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
            this.key = key;
            this.interceptors = new ArrayList<InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>();
        }

        private void addIn(InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>> interceptor) {
            this.interceptors.add(interceptor);
        }

        private InterceptorHolder<HttpServerRequest<I>, HttpKeyEvaluationContext, InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>> buildHolder() {
            return new InterceptorHolder(this.key, this.interceptors);
        }
    }

    public static class GovernatorHttpAttacher<I, O>
    extends AbstractAttacher<HttpServerRequest<I>, HttpServerResponse<O>, HttpKeyEvaluationContext, GovernatorHttpInterceptorSupport<I, O>> {
        public GovernatorHttpAttacher(GovernatorHttpInterceptorSupport<I, O> support, InterceptorKey<HttpServerRequest<I>, HttpKeyEvaluationContext> key) {
            super(support, key);
        }

        public GovernatorHttpInterceptorSupport<I, O> interceptIn(Class<? extends InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>> interceptor) {
            ArrayList<Class<InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> interceptors = new ArrayList<Class<InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>>();
            interceptors.add(interceptor);
            return this.interceptIn(interceptors);
        }

        public GovernatorHttpInterceptorSupport<I, O> interceptIn(List<Class<? extends InboundInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> interceptors) {
            HttpInClassHolder holder = new HttpInClassHolder(this.key, interceptors);
            ((GovernatorHttpInterceptorSupport)this.interceptorSupport).inboundInterceptorClasses.add(holder);
            return (GovernatorHttpInterceptorSupport)this.interceptorSupport;
        }

        public GovernatorHttpInterceptorSupport<I, O> interceptOut(Class<? extends OutboundInterceptor<HttpServerResponse<O>>> interceptor) {
            ArrayList<Class<OutboundInterceptor<HttpServerResponse<O>>>> interceptors = new ArrayList<Class<OutboundInterceptor<HttpServerResponse<O>>>>();
            interceptors.add(interceptor);
            return this.interceptOut(interceptors);
        }

        public GovernatorHttpInterceptorSupport<I, O> interceptOut(List<Class<? extends OutboundInterceptor<HttpServerResponse<O>>>> interceptors) {
            HttpOutClassHolder holder = new HttpOutClassHolder(this.key, interceptors);
            ((GovernatorHttpInterceptorSupport)this.interceptorSupport).outboundInterceptorClasses.add(holder);
            return (GovernatorHttpInterceptorSupport)this.interceptorSupport;
        }

        public GovernatorHttpInterceptorSupport<I, O> intercept(Class<? extends DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>> interceptor) {
            ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> interceptors = new ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>>();
            interceptors.add(interceptor);
            return this.intercept(interceptors);
        }

        public GovernatorHttpInterceptorSupport<I, O> intercept(List<Class<? extends DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> interceptors) {
            ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> ins = new ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>>();
            ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>> outs = new ArrayList<Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>>>();
            for (Class<DuplexInterceptor<HttpServerRequest<I>, HttpServerResponse<O>>> clazz : interceptors) {
                ins.add(clazz);
                outs.add(clazz);
            }
            HttpInClassHolder inHolder = new HttpInClassHolder(this.key, ins);
            ((GovernatorHttpInterceptorSupport)this.interceptorSupport).inboundInterceptorClasses.add(inHolder);
            HttpOutClassHolder httpOutClassHolder = new HttpOutClassHolder(this.key, outs);
            ((GovernatorHttpInterceptorSupport)this.interceptorSupport).outboundInterceptorClasses.add(httpOutClassHolder);
            return (GovernatorHttpInterceptorSupport)this.interceptorSupport;
        }
    }
}

