/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.transport.KaryonTransport;
import netflix.karyon.transport.http.GovernatorHttpInterceptorSupport;
import netflix.karyon.transport.http.HttpRequestHandler;
import netflix.karyon.transport.http.KaryonHttpModule;
import netflix.karyon.transport.interceptor.AbstractInterceptorSupport;
import netflix.karyon.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRxServerProvider<I, O, S extends HttpServer<I, O>>
implements Provider<S> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRxServerProvider.class);
    private final Named nameAnnotation;
    private final Key<RequestHandler<I, O>> routerKey;
    private final Key<GovernatorHttpInterceptorSupport<I, O>> interceptorSupportKey;
    private final Key<PipelineConfigurator> pipelineConfiguratorKey;
    private final Key<MetricEventsListenerFactory> metricEventsListenerFactoryKey;
    private final Key<AbstractServerModule.ServerConfig> serverConfigKey;
    private volatile HttpServer<I, O> httpServer;

    public HttpRxServerProvider(String name, Class<I> iType, Class<O> oType) {
        this.nameAnnotation = Names.named((String)name);
        this.routerKey = TypeUtils.keyFor(RequestHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.interceptorSupportKey = TypeUtils.keyFor(GovernatorHttpInterceptorSupport.class, iType, oType, (Annotation)this.nameAnnotation);
        this.pipelineConfiguratorKey = Key.get(PipelineConfigurator.class, (Annotation)this.nameAnnotation);
        this.metricEventsListenerFactoryKey = Key.get(MetricEventsListenerFactory.class, (Annotation)this.nameAnnotation);
        this.serverConfigKey = Key.get(AbstractServerModule.ServerConfig.class, (Annotation)this.nameAnnotation);
    }

    public S get() {
        return (S)this.httpServer;
    }

    @PreDestroy
    public void shutdown() throws InterruptedException {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        KaryonHttpModule.HttpServerConfig config = (KaryonHttpModule.HttpServerConfig)injector.getInstance(this.serverConfigKey);
        RequestHandler router = (RequestHandler)injector.getInstance(this.routerKey);
        GovernatorHttpInterceptorSupport interceptorSupport = (GovernatorHttpInterceptorSupport)((Object)injector.getInstance(this.interceptorSupportKey));
        interceptorSupport.finish(injector);
        HttpRequestHandler httpRequestHandler = new HttpRequestHandler(router, (AbstractInterceptorSupport)interceptorSupport);
        HttpServerBuilder builder = KaryonTransport.newHttpServerBuilder((int)config.getPort(), (HttpRequestHandler)httpRequestHandler);
        if (config.requiresThreadPool()) {
            builder.withRequestProcessingThreads(config.getThreadPoolSize());
        }
        if (injector.getExistingBinding(this.pipelineConfiguratorKey) != null) {
            builder.appendPipelineConfigurator((PipelineConfigurator)injector.getInstance(this.pipelineConfiguratorKey));
        }
        if (injector.getExistingBinding(this.metricEventsListenerFactoryKey) != null) {
            builder.withMetricEventsListenerFactory((MetricEventsListenerFactory)injector.getInstance(this.metricEventsListenerFactoryKey));
        }
        this.httpServer = builder.build().start();
        logger.info("Starting server {} on port {}...", (Object)this.nameAnnotation.value(), (Object)this.httpServer.getServerPort());
    }
}

