/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import io.reactivex.netty.server.RxServer;
import java.lang.annotation.Annotation;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.transport.http.GovernatorHttpInterceptorSupport;
import netflix.karyon.transport.http.HttpRxServerProvider;
import netflix.karyon.utils.TypeUtils;

public abstract class KaryonHttpModule<I, O>
extends AbstractServerModule<I, O, HttpServerConfigBuilder> {
    protected final Key<RequestHandler<I, O>> routerKey;
    protected final Key<HttpServer<I, O>> httpServerKey;
    protected final Key<GovernatorHttpInterceptorSupport<I, O>> interceptorSupportKey;
    private final GovernatorHttpInterceptorSupport<I, O> interceptorSupportInstance = new GovernatorHttpInterceptorSupport();

    protected KaryonHttpModule(String moduleName, Class<I> iType, Class<O> oType) {
        super(moduleName, iType, oType);
        this.routerKey = TypeUtils.keyFor(RequestHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.interceptorSupportKey = TypeUtils.keyFor(GovernatorHttpInterceptorSupport.class, iType, oType, (Annotation)this.nameAnnotation);
        this.httpServerKey = TypeUtils.keyFor(HttpServer.class, iType, oType, (Annotation)this.nameAnnotation);
    }

    protected void configure() {
        this.configureServer();
        this.bind(this.serverConfigKey).toInstance((Object)((HttpServerConfigBuilder)this.serverConfigBuilder).build());
        this.bind(this.interceptorSupportKey).toInstance(this.interceptorSupportInstance);
        MapBinder.newMapBinder((Binder)this.binder(), String.class, RxServer.class).addBinding((Object)this.nameAnnotation.value()).toProvider(new HttpRxServerProvider(this.nameAnnotation.value(), this.iType, this.oType)).asEagerSingleton();
    }

    @Override
    protected HttpServerConfigBuilder newServerConfigBuilder() {
        return new HttpServerConfigBuilder();
    }

    protected LinkedBindingBuilder<RequestHandler<I, O>> bindRouter() {
        return this.bind(this.routerKey);
    }

    protected GovernatorHttpInterceptorSupport<I, O> interceptorSupport() {
        return this.interceptorSupportInstance;
    }

    public static class HttpServerConfigBuilder
    extends AbstractServerModule.ServerConfigBuilder<HttpServerConfigBuilder, HttpServerConfig> {
        protected int poolSize = -1;

        public HttpServerConfigBuilder threadPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        @Override
        public HttpServerConfig build() {
            return new HttpServerConfig(this.port, this.poolSize);
        }
    }

    public static class HttpServerConfig
    extends AbstractServerModule.ServerConfig {
        private final int threadPoolSize;

        public HttpServerConfig(int port) {
            super(port);
            this.threadPoolSize = -1;
        }

        public HttpServerConfig(int port, int threadPoolSize) {
            super(port);
            this.threadPoolSize = threadPoolSize;
        }

        public int getThreadPoolSize() {
            return this.threadPoolSize;
        }

        public boolean requiresThreadPool() {
            return this.threadPoolSize > 0;
        }
    }
}

