/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http.websockets;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.server.RxServer;
import java.lang.annotation.Annotation;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.transport.http.websockets.WebSocketsRxServerProvider;
import netflix.karyon.utils.TypeUtils;

public abstract class KaryonWebSocketsModule<I extends WebSocketFrame, O extends WebSocketFrame>
extends AbstractServerModule<I, O, WebSocketsServerConfigBuilder> {
    protected final Key<ConnectionHandler<I, O>> connectionHandlerKey;
    protected final Key<RxServer<I, O>> serverKey;

    protected KaryonWebSocketsModule(String moduleName, Class<I> iType, Class<O> oType) {
        super(moduleName, iType, oType);
        this.connectionHandlerKey = TypeUtils.keyFor(ConnectionHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.serverKey = TypeUtils.keyFor(RxServer.class, iType, oType, (Annotation)this.nameAnnotation);
    }

    protected void configure() {
        this.configureServer();
        this.bind(this.serverConfigKey).toInstance((Object)((WebSocketsServerConfigBuilder)this.serverConfigBuilder).build());
        MapBinder.newMapBinder((Binder)this.binder(), String.class, RxServer.class).addBinding((Object)this.nameAnnotation.value()).toProvider(new WebSocketsRxServerProvider(this.nameAnnotation.value(), this.iType, this.oType)).asEagerSingleton();
    }

    @Override
    protected WebSocketsServerConfigBuilder newServerConfigBuilder() {
        return new WebSocketsServerConfigBuilder();
    }

    public LinkedBindingBuilder<ConnectionHandler<I, O>> bindConnectionHandler() {
        return this.bind(this.connectionHandlerKey);
    }

    public static class WebSocketsServerConfigBuilder
    extends AbstractServerModule.ServerConfigBuilder<WebSocketsServerConfigBuilder, WebSocketsServerConfig> {
        protected boolean messageAggregator;

        public WebSocketsServerConfigBuilder withMessageAggregator(boolean messageAggregator) {
            this.messageAggregator = messageAggregator;
            return this;
        }

        @Override
        public WebSocketsServerConfig build() {
            return new WebSocketsServerConfig(this.port, this.messageAggregator);
        }
    }

    public static class WebSocketsServerConfig
    extends AbstractServerModule.ServerConfig {
        private final boolean messageAggregator;

        public WebSocketsServerConfig(int port, boolean messageAggregator) {
            super(port);
            this.messageAggregator = messageAggregator;
        }

        public boolean isMessageAggregator() {
            return this.messageAggregator;
        }
    }
}

