/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.http.websockets;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.websocket.WebSocketServerBuilder;
import io.reactivex.netty.server.RxServer;
import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.transport.http.websockets.KaryonWebSocketsModule;
import netflix.karyon.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketsRxServerProvider<I extends WebSocketFrame, O extends WebSocketFrame, S extends RxServer<I, O>>
implements Provider<S> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketsRxServerProvider.class);
    private final Named nameAnnotation;
    protected final Key<ConnectionHandler<I, O>> connectionHandlerKey;
    private final Key<PipelineConfigurator> pipelineConfiguratorKey;
    private final Key<MetricEventsListenerFactory> metricEventsListenerFactoryKey;
    private final Key<AbstractServerModule.ServerConfig> serverConfigKey;
    private RxServer<I, O> server;

    public WebSocketsRxServerProvider(String name, Class<I> iType, Class<O> oType) {
        this.nameAnnotation = Names.named((String)name);
        this.connectionHandlerKey = TypeUtils.keyFor(ConnectionHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.pipelineConfiguratorKey = Key.get(PipelineConfigurator.class, (Annotation)this.nameAnnotation);
        this.metricEventsListenerFactoryKey = Key.get(MetricEventsListenerFactory.class, (Annotation)this.nameAnnotation);
        this.serverConfigKey = Key.get(AbstractServerModule.ServerConfig.class, (Annotation)this.nameAnnotation);
    }

    public S get() {
        return (S)this.server;
    }

    @PreDestroy
    public void shutdown() throws InterruptedException {
        if (this.server != null) {
            logger.info("Starting WebSockets server {} on port {}...", (Object)this.nameAnnotation.value(), (Object)this.server.getServerPort());
            this.server.shutdown();
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        KaryonWebSocketsModule.WebSocketsServerConfig config = (KaryonWebSocketsModule.WebSocketsServerConfig)injector.getInstance(this.serverConfigKey);
        ConnectionHandler connectionHandler = (ConnectionHandler)injector.getInstance(this.connectionHandlerKey);
        WebSocketServerBuilder builder = RxNetty.newWebSocketServerBuilder((int)config.getPort(), (ConnectionHandler)connectionHandler).withMessageAggregator(config.isMessageAggregator());
        if (injector.getExistingBinding(this.pipelineConfiguratorKey) != null) {
            builder.appendPipelineConfigurator((PipelineConfigurator)injector.getInstance(this.pipelineConfiguratorKey));
        }
        if (injector.getExistingBinding(this.metricEventsListenerFactoryKey) != null) {
            builder.withMetricEventsListenerFactory((MetricEventsListenerFactory)injector.getInstance(this.metricEventsListenerFactoryKey));
        }
        this.server = (RxServer)builder.build().start();
        logger.info("Starting WebSockets server {} on port {}...", (Object)this.nameAnnotation.value(), (Object)this.server.getServerPort());
    }
}

