/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.tcp;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.server.RxServer;
import java.lang.annotation.Annotation;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.transport.tcp.TcpRxServerProvider;
import netflix.karyon.utils.TypeUtils;

public abstract class KaryonTcpModule<I, O>
extends AbstractServerModule<I, O, AbstractServerModule.ServerConfigBuilder> {
    protected final Key<ConnectionHandler<I, O>> connectionHandlerKey;
    protected final Key<RxServer<I, O>> serverKey;

    protected KaryonTcpModule(String moduleName, Class<I> iType, Class<O> oType) {
        super(moduleName, iType, oType);
        this.connectionHandlerKey = TypeUtils.keyFor(ConnectionHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.serverKey = TypeUtils.keyFor(RxServer.class, iType, oType, (Annotation)this.nameAnnotation);
    }

    protected void configure() {
        this.configureServer();
        this.bind(this.serverConfigKey).toInstance(this.serverConfigBuilder.build());
        MapBinder.newMapBinder((Binder)this.binder(), String.class, RxServer.class).addBinding((Object)this.nameAnnotation.value()).toProvider(new TcpRxServerProvider(this.nameAnnotation.value(), this.iType, this.oType)).asEagerSingleton();
    }

    @Override
    protected AbstractServerModule.ServerConfigBuilder newServerConfigBuilder() {
        return new AbstractServerModule.ServerConfigBuilder();
    }

    public LinkedBindingBuilder<ConnectionHandler<I, O>> bindConnectionHandler() {
        return this.bind(this.connectionHandlerKey);
    }
}

