/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.tcp;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.metrics.MetricEventsListenerFactory;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.server.RxServer;
import io.reactivex.netty.server.ServerBuilder;
import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import netflix.karyon.transport.AbstractServerModule;
import netflix.karyon.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpRxServerProvider<I, O, S extends RxServer<I, O>>
implements Provider<S> {
    private static final Logger logger = LoggerFactory.getLogger(TcpRxServerProvider.class);
    private final Named nameAnnotation;
    protected final Key<ConnectionHandler<I, O>> connectionHandlerKey;
    private final Key<PipelineConfigurator> pipelineConfiguratorKey;
    private final Key<MetricEventsListenerFactory> metricEventsListenerFactoryKey;
    private final Key<AbstractServerModule.ServerConfig> serverConfigKey;
    private RxServer<I, O> server;

    public TcpRxServerProvider(String name, Class<I> iType, Class<O> oType) {
        this.nameAnnotation = Names.named((String)name);
        this.connectionHandlerKey = TypeUtils.keyFor(ConnectionHandler.class, iType, oType, (Annotation)this.nameAnnotation);
        this.pipelineConfiguratorKey = Key.get(PipelineConfigurator.class, (Annotation)this.nameAnnotation);
        this.metricEventsListenerFactoryKey = Key.get(MetricEventsListenerFactory.class, (Annotation)this.nameAnnotation);
        this.serverConfigKey = Key.get(AbstractServerModule.ServerConfig.class, (Annotation)this.nameAnnotation);
    }

    public S get() {
        return (S)this.server;
    }

    @PreDestroy
    public void shutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        AbstractServerModule.ServerConfig config = (AbstractServerModule.ServerConfig)injector.getInstance(this.serverConfigKey);
        ConnectionHandler connectionHandler = (ConnectionHandler)injector.getInstance(this.connectionHandlerKey);
        ServerBuilder builder = RxNetty.newTcpServerBuilder((int)config.getPort(), (ConnectionHandler)connectionHandler);
        if (injector.getExistingBinding(this.pipelineConfiguratorKey) != null) {
            builder.appendPipelineConfigurator((PipelineConfigurator)injector.getInstance(this.pipelineConfiguratorKey));
        }
        if (injector.getExistingBinding(this.metricEventsListenerFactoryKey) != null) {
            builder.withMetricEventsListenerFactory((MetricEventsListenerFactory)injector.getInstance(this.metricEventsListenerFactoryKey));
        }
        this.server = (RxServer)((RxServer)builder.build()).start();
        logger.info("Starting server {} on port {}...", (Object)this.nameAnnotation.value(), (Object)this.server.getServerPort());
    }
}

