/*
 * Decompiled with CFR 0.152.
 */
package netflix.karyon.transport.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;

public class HttpContentInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(HttpContentInputStream.class);
    private final Lock lock = new ReentrantLock();
    private volatile boolean isClosed = false;
    private volatile boolean isCompleted = false;
    private volatile Throwable completedWithError = null;
    private final Condition contentAvailabilityMonitor = this.lock.newCondition();
    private final ByteBuf contentBuffer;

    public HttpContentInputStream(ByteBufAllocator allocator, Observable<ByteBuf> content) {
        this.contentBuffer = allocator.buffer();
        content.subscribe((Observer)new Observer<ByteBuf>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted() {
                HttpContentInputStream.this.lock.lock();
                try {
                    HttpContentInputStream.this.isCompleted = true;
                    logger.debug("Processing complete");
                    HttpContentInputStream.this.contentAvailabilityMonitor.signalAll();
                }
                finally {
                    HttpContentInputStream.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(Throwable e) {
                HttpContentInputStream.this.lock.lock();
                try {
                    HttpContentInputStream.this.completedWithError = e;
                    HttpContentInputStream.this.isCompleted = true;
                    logger.error("Observer, got error: " + e.getMessage());
                    HttpContentInputStream.this.contentAvailabilityMonitor.signalAll();
                }
                finally {
                    HttpContentInputStream.this.lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuf byteBuf) {
                HttpContentInputStream.this.lock.lock();
                try {
                    if (byteBuf.readableBytes() > 0) {
                        HttpContentInputStream.this.contentBuffer.writeBytes(byteBuf);
                    }
                    HttpContentInputStream.this.contentAvailabilityMonitor.signalAll();
                }
                catch (Exception e) {
                    logger.error("Error on server", (Throwable)e);
                }
                finally {
                    HttpContentInputStream.this.lock.unlock();
                }
            }
        });
    }

    @Override
    public int available() throws IOException {
        return this.isCompleted ? this.contentBuffer.readableBytes() : 0;
    }

    @Override
    public void mark(int readlimit) {
        this.contentBuffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.lock.lock();
        try {
            if (!this.await()) {
                int n = -1;
                return n;
            }
            int n = this.contentBuffer.readByte() & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Null buffer");
        }
        if (len < 0 || off < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Invalid index");
        }
        if (len == 0) {
            return 0;
        }
        this.lock.lock();
        try {
            if (!this.await()) {
                int n = -1;
                return n;
            }
            int size = Math.min(len, this.contentBuffer.readableBytes());
            this.contentBuffer.readBytes(b, off, size);
            int n = size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        HttpContentInputStream httpContentInputStream = this;
        synchronized (httpContentInputStream) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.contentBuffer.release();
    }

    @Override
    public void reset() throws IOException {
        this.contentBuffer.resetReaderIndex();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (n > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)n);
    }

    private int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.contentBuffer.skipBytes(nBytes);
        return nBytes;
    }

    private boolean await() throws IOException {
        while (!this.isCompleted && !this.contentBuffer.isReadable()) {
            try {
                this.contentAvailabilityMonitor.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Interrupted: " + e.getMessage());
                throw new IOException(e);
            }
        }
        if (this.completedWithError != null) {
            throw new IOException(this.completedWithError);
        }
        return !this.isCompleted || this.contentBuffer.isReadable();
    }
}

