/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.metacat.server.init;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.netflix.blitz4j.LoggingConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.metacat.common.server.Config;
import com.netflix.metacat.main.init.MetacatInitializationService;
import com.netflix.metacat.main.init.MetacatServletModule;
import com.netflix.metacat.usermetadata.mysql.MysqlUserMetadataModule;
import com.squarespace.jersey2.guice.JerseyGuiceServletContextListener;
import com.wordnik.swagger.jaxrs.config.BeanConfig;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetacatContextListener
extends JerseyGuiceServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(MetacatContextListener.class);

    public void contextDestroyed(ServletContextEvent sce) {
        log.info("Start contextDestroyed");
        super.contextDestroyed(sce);
        LoggingConfiguration.getInstance().stop();
        MetacatInitializationService service = (MetacatInitializationService)this.getInjector().getInstance(MetacatInitializationService.class);
        try {
            service.stop();
        }
        catch (Throwable t) {
            log.error("Error stopping Metacat", t);
            throw Throwables.propagate((Throwable)t);
        }
        log.info("Finish contextDestroyed");
    }

    public void contextInitialized(ServletContextEvent sce) {
        log.info("Start contextInitialized");
        super.contextInitialized(sce);
        Config config = (Config)this.getInjector().getInstance(Config.class);
        MetacatInitializationService service = (MetacatInitializationService)this.getInjector().getInstance(MetacatInitializationService.class);
        try {
            service.start();
        }
        catch (Throwable t) {
            log.error("Error initializing Metacat", t);
            throw Throwables.propagate((Throwable)t);
        }
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion(config.getMetacatVersion());
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage("com.netflix.metacat");
        beanConfig.setScan(true);
        log.info("Finish contextInitialized");
    }

    protected List<? extends Module> modules() {
        return ImmutableList.of((Object)new MetacatServletModule(), (Object)new MysqlUserMetadataModule());
    }

    static {
        System.setProperty("archaius.deployment.applicationId", "metacat");
        try {
            ConfigurationManager.loadCascadedPropertiesFromResources((String)"metacat");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoggingConfiguration.getInstance().configure();
    }
}

