/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.metacat.server.jersey;

import com.netflix.metacat.common.MetacatRequestContext;
import com.netflix.metacat.common.util.MetacatContextManager;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MetacatRestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(MetacatRestFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String userName = requestContext.getHeaderString("X-Netflix.user.name");
        if (userName == null) {
            userName = "metacat";
        }
        String clientAppName = requestContext.getHeaderString("X-Netflix.client.app.name");
        String clientHost = requestContext.getHeaderString("X-Forwarded-For");
        String jobId = requestContext.getHeaderString("X-Netflix.job.id");
        MetacatRequestContext.DataTypeContext dataTypeContext = (MetacatRequestContext.DataTypeContext)EnumUtils.getEnum(MetacatRequestContext.DataTypeContext.class, (String)requestContext.getHeaderString("X-Netflix.data.type.context"));
        MetacatRequestContext context = new MetacatRequestContext(userName, clientAppName, clientHost, jobId, dataTypeContext);
        MetacatContextManager.setContext((MetacatRequestContext)context);
        log.info(context.toString());
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        MetacatContextManager.removeContext();
    }
}

